/*
 * Decompiled with CFR 0.152.
 */
package operatonjar.impl.com.cronutils.model.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import operatonjar.impl.com.cronutils.model.time.NearestValue;
import operatonjar.impl.com.cronutils.utils.Preconditions;
import operatonjar.impl.com.cronutils.utils.VisibleForTesting;

class TimeNode {
    protected List<Integer> values;

    public TimeNode(List<Integer> values) {
        this.values = Preconditions.checkNotNullNorEmpty(values, (Object)"Values must not be empty");
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int reference, int shifts) {
        return this.getNearestForwardValue(reference, shifts);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public NearestValue getPreviousValue(int reference, int shifts) {
        return this.getNearestBackwardValue(reference, shifts);
    }

    @VisibleForTesting
    NearestValue getNearestForwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> temporaryValues = new ArrayList<Integer>(this.values);
        int index = 0;
        boolean foundGreater = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!temporaryValues.contains(reference)) {
            for (Integer value : temporaryValues) {
                if (value <= reference) continue;
                index = temporaryValues.indexOf(value);
                --shiftsToApply;
                foundGreater = true;
                break;
            }
            if (!foundGreater) {
                shift.incrementAndGet();
            }
        } else {
            index = temporaryValues.indexOf(reference);
        }
        int value = (Integer)temporaryValues.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(temporaryValues, index + 1, shift);
            index = temporaryValues.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    NearestValue getNearestBackwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> temporaryValues = new ArrayList<Integer>(this.values);
        Collections.reverse(temporaryValues);
        int index = 0;
        boolean foundSmaller = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!temporaryValues.contains(reference)) {
            for (Integer value : temporaryValues) {
                if (value >= reference) continue;
                index = temporaryValues.indexOf(value);
                --shiftsToApply;
                foundSmaller = true;
                break;
            }
            if (!foundSmaller) {
                shift.incrementAndGet();
            }
        } else {
            index = temporaryValues.indexOf(reference);
        }
        int value = (Integer)temporaryValues.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(temporaryValues, index + 1, shift);
            index = temporaryValues.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    int getValueFromList(List<Integer> values, int index, AtomicInteger shift) {
        Preconditions.checkNotNullNorEmpty(values, (Object)"List must not be empty");
        if (index < 0) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index += values.size(), shift);
        }
        if (index >= values.size()) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index -= values.size(), shift);
        }
        return values.get(index);
    }
}

