/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.container.impl.metadata;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.container.impl.ContainerIntegrationLogger;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.ReflectUtil;

public final class PropertyHelper {
    protected static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    public static final String KEBAB_CASE = "-";
    public static final String SNAKE_CASE = "_";
    public static final String CAMEL_CASE = "";
    private static final Pattern PROPERTY_TEMPLATE = Pattern.compile("([^\\$]*)\\$\\{(.+?)\\}([^\\$]*)");

    private PropertyHelper() {
    }

    public static boolean getBooleanProperty(Map<String, String> properties, String name, boolean defaultValue) {
        String value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static Object convertToClass(String value, Class<?> clazz) {
        Object propertyValue = clazz.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(Integer.parseInt(value)) : (clazz.isAssignableFrom(Long.TYPE) ? Long.valueOf(Long.parseLong(value)) : (clazz.isAssignableFrom(Float.TYPE) ? Float.valueOf(Float.parseFloat(value)) : (clazz.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(Boolean.parseBoolean(value)) : value)));
        return propertyValue;
    }

    public static void applyProperty(Object configuration, String key, String stringValue) {
        Class<?> configurationClass = configuration.getClass();
        Method setter = ReflectUtil.getSingleSetter(key, configurationClass);
        if (setter != null) {
            try {
                Class<?> parameterClass = setter.getParameterTypes()[0];
                Object value = PropertyHelper.convertToClass(stringValue, parameterClass);
                setter.invoke(configuration, value);
            }
            catch (Exception e) {
                throw LOG.cannotSetValueForProperty(key, configurationClass.getCanonicalName(), e);
            }
        } else {
            throw LOG.cannotFindSetterForProperty(key, configurationClass.getCanonicalName());
        }
    }

    public static void applyProperties(Object configuration, Map<String, String> properties, String namingStrategy) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String key = property.getKey();
            if (!CAMEL_CASE.equals(namingStrategy)) {
                key = PropertyHelper.convertToCamelCase(key, namingStrategy);
            }
            PropertyHelper.applyProperty(configuration, key, property.getValue());
        }
    }

    public static void applyProperties(Object configuration, Map<String, String> properties) {
        PropertyHelper.applyProperties(configuration, properties, CAMEL_CASE);
    }

    public static String resolveProperty(Properties props, String original) {
        Matcher matcher = PROPERTY_TEMPLATE.matcher(original);
        StringBuilder buffer = new StringBuilder();
        boolean found = false;
        while (matcher.find()) {
            found = true;
            String propertyName = matcher.group(2).trim();
            buffer.append(matcher.group(1)).append(props.containsKey(propertyName) ? props.getProperty(propertyName) : CAMEL_CASE).append(matcher.group(3));
        }
        return found ? buffer.toString() : original;
    }

    protected static String convertToCamelCase(String value, String token) {
        while (value.contains(token)) {
            value = value.replaceFirst(token + "[a-z]", String.valueOf(Character.toUpperCase(value.charAt(value.indexOf(token) + 1))));
        }
        return value;
    }
}

