/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.IdGenerator;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.core.model.Properties;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.deploy.Deployer;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.repository.ResourceDefinitionEntity;

public abstract class AbstractDefinitionDeployer<DEFINITION_ENTITY extends ResourceDefinitionEntity>
implements Deployer {
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected IdGenerator idGenerator;

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public void deploy(DeploymentEntity deployment) {
        LOG.debugProcessingDeployment(deployment.getName());
        Properties properties = new Properties();
        List<DEFINITION_ENTITY> definitions = this.parseDefinitionResources(deployment, properties);
        this.ensureNoDuplicateDefinitionKeys(definitions);
        this.postProcessDefinitions(deployment, definitions, properties);
    }

    protected List<DEFINITION_ENTITY> parseDefinitionResources(DeploymentEntity deployment, Properties properties) {
        ArrayList<DEFINITION_ENTITY> definitions = new ArrayList<DEFINITION_ENTITY>();
        for (ResourceEntity resource : deployment.getResources().values()) {
            LOG.debugProcessingResource(resource.getName());
            if (!this.isResourceHandled(resource)) continue;
            definitions.addAll(this.transformResource(deployment, resource, properties));
        }
        return definitions;
    }

    protected boolean isResourceHandled(ResourceEntity resource) {
        String resourceName = resource.getName();
        for (String suffix : this.getResourcesSuffixes()) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getResourcesSuffixes();

    protected Collection<DEFINITION_ENTITY> transformResource(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        String resourceName = resource.getName();
        List<DEFINITION_ENTITY> definitions = this.transformDefinitions(deployment, resource, properties);
        for (ResourceDefinitionEntity definition : definitions) {
            definition.setResourceName(resourceName);
            String diagramResourceName = this.getDiagramResourceForDefinition(deployment, resourceName, definition, deployment.getResources());
            if (diagramResourceName == null) continue;
            definition.setDiagramResourceName(diagramResourceName);
        }
        return definitions;
    }

    protected abstract List<DEFINITION_ENTITY> transformDefinitions(DeploymentEntity var1, ResourceEntity var2, Properties var3);

    protected String getDiagramResourceForDefinition(DeploymentEntity deployment, String resourceName, DEFINITION_ENTITY definition, Map<String, ResourceEntity> resources) {
        for (String diagramSuffix : this.getDiagramSuffixes()) {
            String definitionDiagramResource = this.getDefinitionDiagramResourceName(resourceName, definition, diagramSuffix);
            String diagramForFileResource = this.getGeneralDiagramResourceName(resourceName, definition, diagramSuffix);
            if (resources.containsKey(definitionDiagramResource)) {
                return definitionDiagramResource;
            }
            if (!resources.containsKey(diagramForFileResource)) continue;
            return diagramForFileResource;
        }
        return null;
    }

    protected String getDefinitionDiagramResourceName(String resourceName, DEFINITION_ENTITY definition, String diagramSuffix) {
        String fileResourceBase = this.stripDefinitionFileSuffix(resourceName);
        String definitionKey = definition.getKey();
        return fileResourceBase + definitionKey + "." + diagramSuffix;
    }

    protected String getGeneralDiagramResourceName(String resourceName, DEFINITION_ENTITY definition, String diagramSuffix) {
        String fileResourceBase = this.stripDefinitionFileSuffix(resourceName);
        return fileResourceBase + diagramSuffix;
    }

    protected String stripDefinitionFileSuffix(String resourceName) {
        for (String suffix : this.getResourcesSuffixes()) {
            if (!resourceName.endsWith(suffix)) continue;
            return resourceName.substring(0, resourceName.length() - suffix.length());
        }
        return resourceName;
    }

    protected String[] getDiagramSuffixes() {
        return DIAGRAM_SUFFIXES;
    }

    protected void ensureNoDuplicateDefinitionKeys(List<DEFINITION_ENTITY> definitions) {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceDefinitionEntity definition : definitions) {
            String key = definition.getKey();
            if (keys.contains(key)) {
                throw new ProcessEngineException("The deployment contains definitions with the same key '" + key + "' (id attribute), this is not allowed");
            }
            keys.add(key);
        }
    }

    protected void postProcessDefinitions(DeploymentEntity deployment, List<DEFINITION_ENTITY> definitions, Properties properties) {
        if (deployment.isNew()) {
            this.persistDefinitions(deployment, definitions, properties);
        } else {
            this.loadDefinitions(deployment, definitions, properties);
        }
    }

    protected void persistDefinitions(DeploymentEntity deployment, List<DEFINITION_ENTITY> definitions, Properties properties) {
        for (ResourceDefinitionEntity definition : definitions) {
            String definitionKey = definition.getKey();
            String tenantId = deployment.getTenantId();
            DEFINITION_ENTITY latestDefinition = this.findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
            this.updateDefinitionByLatestDefinition(deployment, definition, latestDefinition);
            this.persistDefinition(definition);
            this.registerDefinition(deployment, definition, properties);
        }
    }

    protected void updateDefinitionByLatestDefinition(DeploymentEntity deployment, DEFINITION_ENTITY definition, DEFINITION_ENTITY latestDefinition) {
        definition.setVersion(this.getNextVersion(deployment, definition, latestDefinition));
        definition.setId(this.generateDefinitionId(deployment, definition, latestDefinition));
        definition.setDeploymentId(deployment.getId());
        definition.setTenantId(deployment.getTenantId());
    }

    protected void loadDefinitions(DeploymentEntity deployment, List<DEFINITION_ENTITY> definitions, Properties properties) {
        for (ResourceDefinitionEntity definition : definitions) {
            String deploymentId = deployment.getId();
            String definitionKey = definition.getKey();
            DEFINITION_ENTITY persistedDefinition = this.findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
            this.handlePersistedDefinition(definition, persistedDefinition, deployment, properties);
        }
    }

    protected void handlePersistedDefinition(DEFINITION_ENTITY definition, DEFINITION_ENTITY persistedDefinition, DeploymentEntity deployment, Properties properties) {
        this.persistedDefinitionLoaded(deployment, definition, persistedDefinition);
        this.updateDefinitionByPersistedDefinition(deployment, definition, persistedDefinition);
        this.registerDefinition(deployment, definition, properties);
    }

    protected void updateDefinitionByPersistedDefinition(DeploymentEntity deployment, DEFINITION_ENTITY definition, DEFINITION_ENTITY persistedDefinition) {
        definition.setVersion(persistedDefinition.getVersion());
        definition.setId(persistedDefinition.getId());
        definition.setDeploymentId(deployment.getId());
        definition.setTenantId(persistedDefinition.getTenantId());
    }

    protected void persistedDefinitionLoaded(DeploymentEntity deployment, DEFINITION_ENTITY definition, DEFINITION_ENTITY persistedDefinition) {
    }

    protected abstract DEFINITION_ENTITY findDefinitionByDeploymentAndKey(String var1, String var2);

    protected abstract DEFINITION_ENTITY findLatestDefinitionByKeyAndTenantId(String var1, String var2);

    protected abstract void persistDefinition(DEFINITION_ENTITY var1);

    protected void registerDefinition(DeploymentEntity deployment, DEFINITION_ENTITY definition, Properties properties) {
        DeploymentCache deploymentCache = this.getDeploymentCache();
        this.addDefinitionToDeploymentCache(deploymentCache, definition);
        this.definitionAddedToDeploymentCache(deployment, definition, properties);
        deployment.addDeployedArtifact((ResourceDefinitionEntity)definition);
    }

    protected abstract void addDefinitionToDeploymentCache(DeploymentCache var1, DEFINITION_ENTITY var2);

    protected void definitionAddedToDeploymentCache(DeploymentEntity deployment, DEFINITION_ENTITY definition, Properties properties) {
    }

    protected int getNextVersion(DeploymentEntity deployment, DEFINITION_ENTITY newDefinition, DEFINITION_ENTITY latestDefinition) {
        int result = 1;
        if (latestDefinition != null) {
            int latestVersion = latestDefinition.getVersion();
            result = latestVersion + 1;
        }
        return result;
    }

    protected String generateDefinitionId(DeploymentEntity deployment, DEFINITION_ENTITY newDefinition, DEFINITION_ENTITY latestDefinition) {
        int definitionVersion;
        String nextId = this.idGenerator.getNextId();
        String definitionKey = newDefinition.getKey();
        Object definitionId = definitionKey + ":" + (definitionVersion = newDefinition.getVersion()) + ":" + nextId;
        if (((String)definitionId).length() > 64) {
            definitionId = nextId;
        }
        return definitionId;
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return Context.getProcessEngineConfiguration();
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected DeploymentCache getDeploymentCache() {
        return this.getProcessEngineConfiguration().getDeploymentCache();
    }
}

