/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ActivityInstance;

public class ActivityExecutionTreeMapping {
    protected Map<ScopeImpl, Set<ExecutionEntity>> activityExecutionMapping = new HashMap<ScopeImpl, Set<ExecutionEntity>>();
    protected CommandContext commandContext;
    protected String processInstanceId;
    protected ProcessDefinitionImpl processDefinition;

    public ActivityExecutionTreeMapping(CommandContext commandContext, String processInstanceId) {
        this.commandContext = commandContext;
        this.processInstanceId = processInstanceId;
        this.initialize();
    }

    protected void submitExecution(ExecutionEntity execution, ScopeImpl scope) {
        this.getExecutions(scope).add(execution);
    }

    public Set<ExecutionEntity> getExecutions(ScopeImpl activity) {
        return this.activityExecutionMapping.computeIfAbsent(activity, k -> new HashSet());
    }

    public ExecutionEntity getExecution(ActivityInstance activityInstance) {
        ScopeImpl scope = null;
        scope = activityInstance.getId().equals(activityInstance.getProcessInstanceId()) ? this.processDefinition : this.processDefinition.findActivity(activityInstance.getActivityId());
        return this.intersect(this.getExecutions(scope), activityInstance.getExecutionIds());
    }

    protected ExecutionEntity intersect(Set<ExecutionEntity> executions, String[] executionIds) {
        HashSet<String> executionIdSet = new HashSet<String>(Arrays.asList(executionIds));
        return executions.stream().filter(execution -> executionIdSet.contains(execution.getId())).findFirst().orElseThrow(() -> new ProcessEngineException("Could not determine execution"));
    }

    protected void initialize() {
        ExecutionEntity processInstance = this.commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        this.processDefinition = processInstance.getProcessDefinition();
        List<ExecutionEntity> executions = this.fetchExecutionsForProcessInstance(processInstance);
        executions.add(processInstance);
        List<ExecutionEntity> leaves = this.findLeaves(executions);
        this.assignExecutionsToActivities(leaves);
    }

    protected void assignExecutionsToActivities(List<ExecutionEntity> leaves) {
        for (ExecutionEntity leaf : leaves) {
            ActivityImpl activity = leaf.getActivity();
            if (activity != null) {
                if (leaf.getActivityInstanceId() != null) {
                    EnsureUtil.ensureNotNull("activity", (Object)activity);
                    this.submitExecution(leaf, activity);
                }
                this.mergeScopeExecutions(leaf);
                continue;
            }
            if (!leaf.isProcessInstanceExecution()) continue;
            this.submitExecution(leaf, leaf.getProcessDefinition());
        }
    }

    protected void mergeScopeExecutions(ExecutionEntity leaf) {
        Map<ScopeImpl, PvmExecutionImpl> mapping = leaf.createActivityExecutionMapping();
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> mappingEntry : mapping.entrySet()) {
            ScopeImpl scope = mappingEntry.getKey();
            ExecutionEntity scopeExecution = (ExecutionEntity)mappingEntry.getValue();
            this.submitExecution(scopeExecution, scope);
        }
    }

    protected List<ExecutionEntity> fetchExecutionsForProcessInstance(ExecutionEntity execution) {
        ArrayList<ExecutionEntity> executions = new ArrayList<ExecutionEntity>();
        executions.addAll(execution.getExecutions());
        for (ExecutionEntity child : execution.getExecutions()) {
            executions.addAll(this.fetchExecutionsForProcessInstance(child));
        }
        return executions;
    }

    protected List<ExecutionEntity> findLeaves(List<ExecutionEntity> executions) {
        ArrayList<ExecutionEntity> leaves = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            if (!this.isLeaf(execution)) continue;
            leaves.add(execution);
        }
        return leaves;
    }

    protected boolean isLeaf(ExecutionEntity execution) {
        if (CompensationBehavior.isCompensationThrowing(execution)) {
            return true;
        }
        return !execution.isEventScope() && execution.getNonEventScopeExecutions().isEmpty();
    }
}

