/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.HistoricDecisionInstanceStatistics;
import org.operaton.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class HistoricDecisionInstanceStatisticsQueryImpl
extends AbstractQuery<HistoricDecisionInstanceStatisticsQuery, HistoricDecisionInstanceStatistics>
implements HistoricDecisionInstanceStatisticsQuery {
    protected final String decisionRequirementsDefinitionId;
    protected String decisionInstanceId;

    public HistoricDecisionInstanceStatisticsQueryImpl(String decisionRequirementsDefinitionId, CommandExecutor commandExecutor) {
        super(commandExecutor);
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByDecisionRequirementsDefinition(this);
    }

    @Override
    public List<HistoricDecisionInstanceStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByDecisionRequirementsDefinition(this, page);
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        EnsureUtil.ensureNotNull("decisionRequirementsDefinitionId", (Object)this.decisionRequirementsDefinitionId);
    }

    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    @Override
    public HistoricDecisionInstanceStatisticsQuery decisionInstanceId(String decisionInstanceId) {
        this.setDecisionInstanceId(decisionInstanceId);
        return this;
    }

    public String getDecisionInstanceId() {
        return this.decisionInstanceId;
    }

    public void setDecisionInstanceId(String decisionInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionInstanceId", (Object)decisionInstanceId);
        this.decisionInstanceId = decisionInstanceId;
    }
}

