/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.HistoricProcessInstanceQuery;
import org.operaton.bpm.engine.impl.batch.RestartProcessInstancesBatchCmd;
import org.operaton.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.operaton.bpm.engine.impl.cmd.ActivityAfterInstantiationCmd;
import org.operaton.bpm.engine.impl.cmd.ActivityBeforeInstantiationCmd;
import org.operaton.bpm.engine.impl.cmd.RestartProcessInstancesCmd;
import org.operaton.bpm.engine.impl.cmd.TransitionInstantiationCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.RestartProcessInstanceBuilder;

public class RestartProcessInstanceBuilderImpl
implements RestartProcessInstanceBuilder {
    protected CommandExecutor commandExecutor;
    protected List<String> processInstanceIds;
    protected List<AbstractProcessInstanceModificationCommand> instructions;
    protected String processDefinitionId;
    protected HistoricProcessInstanceQuery query;
    protected boolean initialVariables;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;
    protected boolean withoutBusinessKey;

    public RestartProcessInstanceBuilderImpl(CommandExecutor commandExecutor, String processDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionId", (Object)processDefinitionId);
        this.commandExecutor = commandExecutor;
        this.instructions = new ArrayList<AbstractProcessInstanceModificationCommand>();
        this.processDefinitionId = processDefinitionId;
        this.processInstanceIds = new ArrayList<String>();
    }

    public RestartProcessInstanceBuilderImpl(String processDefinitionId) {
        this(null, processDefinitionId);
    }

    @Override
    public RestartProcessInstanceBuilder startBeforeActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.instructions.add(new ActivityBeforeInstantiationCmd(null, activityId));
        return this;
    }

    @Override
    public RestartProcessInstanceBuilder startAfterActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.instructions.add(new ActivityAfterInstantiationCmd(null, activityId));
        return this;
    }

    @Override
    public RestartProcessInstanceBuilder startTransition(String transitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)transitionId);
        this.instructions.add(new TransitionInstantiationCmd(null, transitionId));
        return this;
    }

    @Override
    public void execute() {
        this.commandExecutor.execute(new RestartProcessInstancesCmd(this.commandExecutor, this));
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new RestartProcessInstancesBatchCmd(this.commandExecutor, this));
    }

    public List<AbstractProcessInstanceModificationCommand> getInstructions() {
        return this.instructions;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    @Override
    public RestartProcessInstanceBuilder processInstanceIds(String ... processInstanceIds) {
        this.processInstanceIds.addAll(Arrays.asList(processInstanceIds));
        return this;
    }

    @Override
    public RestartProcessInstanceBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery query) {
        this.query = query;
        return this;
    }

    public HistoricProcessInstanceQuery getHistoricProcessInstanceQuery() {
        return this.query;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setInstructions(List<AbstractProcessInstanceModificationCommand> instructions) {
        this.instructions = instructions;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public RestartProcessInstanceBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds.addAll(processInstanceIds);
        return this;
    }

    @Override
    public RestartProcessInstanceBuilder initialSetOfVariables() {
        this.initialVariables = true;
        return this;
    }

    public boolean isInitialVariables() {
        return this.initialVariables;
    }

    @Override
    public RestartProcessInstanceBuilder skipCustomListeners() {
        this.skipCustomListeners = true;
        return this;
    }

    @Override
    public RestartProcessInstanceBuilder skipIoMappings() {
        this.skipIoMappings = true;
        return this;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMappings;
    }

    @Override
    public RestartProcessInstanceBuilder withoutBusinessKey() {
        this.withoutBusinessKey = true;
        return this;
    }

    public boolean isWithoutBusinessKey() {
        return this.withoutBusinessKey;
    }
}

