/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.ant;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.operaton.bpm.engine.impl.util.IoUtil;

public class LaunchThread
extends Thread {
    Task task;
    String[] cmd;
    File dir;
    String msg;

    public LaunchThread(Task task, String[] cmd, File dir, String msg) {
        this.task = task;
        this.cmd = cmd;
        this.dir = dir;
        this.msg = msg;
    }

    public static void launch(Task task, String[] cmd, File dir, String launchCompleteText) {
        if (cmd == null) {
            throw new BuildException("cmd is null");
        }
        try {
            LaunchThread launchThread = new LaunchThread(task, cmd, dir, launchCompleteText);
            launchThread.start();
            launchThread.join();
        }
        catch (Exception e) {
            throw new BuildException("couldn't launch cmd: " + LaunchThread.cmdString(cmd), (Throwable)e);
        }
    }

    private static String cmdString(String[] cmd) {
        StringBuilder cmdText = new StringBuilder();
        for (String cmdPart : cmd) {
            cmdText.append(cmdPart);
            cmdText.append(" ");
        }
        return cmdText.toString();
    }

    @Override
    public void run() {
        this.task.log("launching cmd '" + LaunchThread.cmdString(this.cmd) + "' in dir '" + String.valueOf(this.dir) + "'");
        if (this.msg != null) {
            this.task.log("waiting for launch completion msg '" + this.msg + "'...");
        } else {
            this.task.log("not waiting for a launch completion msg.");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(this.cmd).redirectErrorStream(true).directory(this.dir);
        Closeable consoleStream = null;
        try {
            Process process = processBuilder.start();
            try (BufferedReader consoleReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String consoleLine = "";
                while (!(consoleLine == null || this.msg != null && consoleLine.contains(this.msg))) {
                    consoleLine = consoleReader.readLine();
                    if (consoleLine != null) {
                        this.task.log("  " + consoleLine);
                        continue;
                    }
                    this.task.log("launched process completed");
                }
            }
        }
        catch (Exception e) {
            throw new BuildException("couldn't launch " + LaunchThread.cmdString(this.cmd), (Throwable)e);
        }
        finally {
            IoUtil.closeSilently(consoleStream);
        }
    }
}

