/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch.deletion;

import java.util.HashSet;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchEntity;
import org.operaton.bpm.engine.impl.batch.BatchJobContext;
import org.operaton.bpm.engine.impl.batch.BatchJobDeclaration;
import org.operaton.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.operaton.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfigurationJsonConverter;
import org.operaton.bpm.engine.impl.cmd.DeleteProcessInstancesCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.MessageEntity;

public class DeleteProcessInstancesJobHandler
extends AbstractBatchJobHandler<DeleteProcessInstanceBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-deletion");

    @Override
    public String getType() {
        return "instance-deletion";
    }

    protected DeleteProcessInstanceBatchConfigurationJsonConverter getJsonConverterInstance() {
        return DeleteProcessInstanceBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected DeleteProcessInstanceBatchConfiguration createJobConfiguration(DeleteProcessInstanceBatchConfiguration configuration, List<String> processIdsForJob) {
        return new DeleteProcessInstanceBatchConfiguration(processIdsForJob, null, configuration.getDeleteReason(), configuration.isSkipCustomListeners(), configuration.isSkipSubprocesses(), configuration.isFailIfNotExists(), configuration.isSkipIoMappings());
    }

    @Override
    public void executeHandler(DeleteProcessInstanceBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        commandContext.executeWithOperationLogPrevented(new DeleteProcessInstancesCmd(batchConfiguration.getIds(), batchConfiguration.getDeleteReason(), batchConfiguration.isSkipCustomListeners(), true, batchConfiguration.isSkipSubprocesses(), batchConfiguration.isFailIfNotExists(), batchConfiguration.isSkipIoMappings()));
    }

    @Override
    protected void createJobEntities(BatchEntity batch, DeleteProcessInstanceBatchConfiguration configuration, String deploymentId, List<String> processIds, int invocationsPerBatchJob) {
        if (deploymentId == null && (configuration.getIdMappings() == null || configuration.getIdMappings().isEmpty())) {
            BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(configuration.getIds()));
            elementConfiguration.addDeploymentMappings(query.listDeploymentIdMappings(), configuration.getIds());
            elementConfiguration.getMappings().forEach(mapping -> super.createJobEntities(batch, configuration, mapping.getDeploymentId(), mapping.getIds(processIds), invocationsPerBatchJob));
        } else {
            super.createJobEntities(batch, configuration, deploymentId, processIds, invocationsPerBatchJob);
        }
    }
}

