/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.delegate.JavaDelegate;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;

public class ClassDelegateActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegateActivityBehavior(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegateActivityBehavior(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        this.executeWithErrorPropagation(execution, () -> {
            this.getActivityBehaviorInstance(execution).execute(execution);
            return null;
        });
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(() -> {
                this.signal(execution, signalName, signalData);
                return null;
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    protected void doSignal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegate;
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegate = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            throw LOG.incorrectlyUsedSignalException(SignallableActivityBehavior.class.getName());
        }
        this.executeWithErrorPropagation(execution, () -> {
            ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
            return null;
        });
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            ActivityBehavior activityBehavior = (ActivityBehavior)delegateInstance;
            return new CustomActivityBehavior(activityBehavior);
        }
        if (delegateInstance instanceof JavaDelegate) {
            JavaDelegate javaDelegate = (JavaDelegate)delegateInstance;
            return new ServiceTaskJavaDelegateActivityBehavior(javaDelegate);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), JavaDelegate.class.getName(), ActivityBehavior.class.getName());
    }
}

