/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.helper;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.helper.EscalationEventDefinitionFinder;
import org.operaton.bpm.engine.impl.bpmn.parser.EscalationEventDefinition;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.PvmScope;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.tree.ActivityExecutionHierarchyWalker;
import org.operaton.bpm.engine.impl.tree.ActivityExecutionMappingCollector;
import org.operaton.bpm.engine.impl.tree.OutputVariablesPropagator;

public final class EscalationHandler {
    private static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    private EscalationHandler() {
    }

    public static void propagateEscalation(ActivityExecution execution, String escalationCode) {
        EscalationEventDefinition escalationEventDefinition = EscalationHandler.executeEscalation(execution, escalationCode);
        if (escalationEventDefinition == null) {
            throw LOG.missingBoundaryCatchEventEscalation(execution.getActivity().getId(), escalationCode);
        }
    }

    public static EscalationEventDefinition executeEscalation(ActivityExecution execution, String escalationCode) {
        PvmActivity currentActivity = execution.getActivity();
        EscalationEventDefinitionFinder escalationEventDefinitionFinder = new EscalationEventDefinitionFinder(escalationCode, currentActivity);
        ActivityExecutionMappingCollector activityExecutionMappingCollector = new ActivityExecutionMappingCollector(execution);
        ActivityExecutionHierarchyWalker walker = new ActivityExecutionHierarchyWalker(execution);
        walker.addScopePreVisitor(escalationEventDefinitionFinder);
        walker.addExecutionPreVisitor(activityExecutionMappingCollector);
        walker.addExecutionPreVisitor(new OutputVariablesPropagator());
        walker.walkUntil(element -> escalationEventDefinitionFinder.getEscalationEventDefinition() != null || element == null);
        EscalationEventDefinition escalationEventDefinition = escalationEventDefinitionFinder.getEscalationEventDefinition();
        if (escalationEventDefinition != null) {
            EscalationHandler.executeEscalationHandler(escalationEventDefinition, activityExecutionMappingCollector, escalationCode);
        }
        return escalationEventDefinition;
    }

    protected static void executeEscalationHandler(EscalationEventDefinition escalationEventDefinition, ActivityExecutionMappingCollector activityExecutionMappingCollector, String escalationCode) {
        PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
        PvmScope escalationScope = EscalationHandler.getScopeForEscalation(escalationEventDefinition);
        PvmExecutionImpl escalationExecution = activityExecutionMappingCollector.getExecutionForScope(escalationScope);
        if (escalationEventDefinition.getEscalationCodeVariable() != null) {
            escalationExecution.setVariable(escalationEventDefinition.getEscalationCodeVariable(), escalationCode);
        }
        escalationExecution.executeActivity(escalationHandler);
    }

    protected static PvmScope getScopeForEscalation(EscalationEventDefinition escalationEventDefinition) {
        PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
        if (escalationEventDefinition.isCancelActivity()) {
            return escalationHandler.getEventScope();
        }
        return escalationHandler.getFlowScope();
    }
}

