/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.calendar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.calendar.DateTimeUtil;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;

public class DurationHelper {
    public static final String PNW_PATTERN = "P\\d+W";
    private static final int MS_PER_WEEK = 604800000;
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    Date start;
    Date end;
    Duration period;
    boolean isRepeat;
    int times;
    long repeatOffset;
    DatatypeFactory datatypeFactory;

    public DurationHelper(String expressions) throws Exception {
        this(expressions, null);
    }

    public DurationHelper(String expressions, Date startDate) throws Exception {
        List<Object> expression = new ArrayList();
        if (expressions != null) {
            expression = Arrays.asList(expressions.split("/"));
        }
        this.datatypeFactory = DatatypeFactory.newInstance();
        if (expression.size() > 3 || expression.isEmpty()) {
            throw LOG.cannotParseDuration(expressions);
        }
        if (((String)expression.get(0)).startsWith("R")) {
            this.isRepeat = true;
            this.times = ((String)expression.get(0)).length() == 1 ? Integer.MAX_VALUE : Integer.parseInt(((String)expression.get(0)).substring(1));
            expression = expression.subList(1, expression.size());
        }
        if (this.isDuration((String)expression.get(0))) {
            this.period = this.parsePeriod((String)expression.get(0));
            this.end = expression.size() == 1 ? null : DateTimeUtil.parseDate((String)expression.get(1));
        } else {
            this.start = DateTimeUtil.parseDate((String)expression.get(0));
            if (this.isDuration((String)expression.get(1))) {
                this.period = this.parsePeriod((String)expression.get(1));
            } else {
                this.end = DateTimeUtil.parseDate((String)expression.get(1));
                this.period = this.datatypeFactory.newDuration(this.end.getTime() - this.start.getTime());
            }
        }
        if (this.start == null && this.end == null) {
            this.start = startDate == null ? ClockUtil.getCurrentTime() : startDate;
        }
    }

    public Date getDateAfter() {
        return this.getDateAfter(null);
    }

    public Date getDateAfter(Date date) {
        if (this.isRepeat) {
            return this.getDateAfterRepeat(date == null ? ClockUtil.getCurrentTime() : date);
        }
        if (this.end != null) {
            return this.end;
        }
        return this.add(this.start, this.period);
    }

    public int getTimes() {
        return this.times;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    private Date getDateAfterRepeat(Date date) {
        Date dateWithoutOffset = new Date(date.getTime() - this.repeatOffset);
        if (this.start != null) {
            Date cur = this.start;
            for (int i = 0; i < this.times && !cur.after(dateWithoutOffset); ++i) {
                cur = this.add(cur, this.period);
            }
            if (cur.before(dateWithoutOffset)) {
                return null;
            }
            return this.repeatOffset == 0L ? cur : new Date(cur.getTime() + this.repeatOffset);
        }
        Date cur = this.add(this.end, this.period.negate());
        Date next = this.end;
        for (int i = 0; i < this.times && cur.after(date); ++i) {
            next = cur;
            cur = this.add(cur, this.period.negate());
        }
        return next.before(date) ? null : next;
    }

    private Date add(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        duration.addTo(calendar);
        return calendar.getTime();
    }

    private Duration parsePeriod(String period) {
        if (period.matches(PNW_PATTERN)) {
            return this.parsePnWDuration(period);
        }
        return this.datatypeFactory.newDuration(period);
    }

    private Duration parsePnWDuration(String period) {
        String weeks = period.replaceAll("\\D", "");
        long duration = Long.parseLong(weeks) * 604800000L;
        return this.datatypeFactory.newDuration(duration);
    }

    private boolean isDuration(String time) {
        return time.startsWith("P");
    }

    public void setRepeatOffset(long repeatOffset) {
        this.repeatOffset = repeatOffset;
    }
}

