/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cfg;

import jakarta.transaction.TransactionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.AbstractTransactionProcessEngineConfiguration;
import org.operaton.bpm.engine.impl.cfg.ConfigurationLogger;
import org.operaton.bpm.engine.impl.cfg.jta.JakartaTransactionContextFactory;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;
import org.operaton.bpm.engine.impl.interceptor.JakartaTransactionInterceptor;

public class JakartaTransactionProcessEngineConfiguration
extends AbstractTransactionProcessEngineConfiguration {
    private static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;
    protected TransactionManager transactionManager;

    @Override
    protected CommandInterceptor createTransactionInterceptor(boolean requiresNew) {
        return new JakartaTransactionInterceptor(this.transactionManager, requiresNew, this);
    }

    @Override
    protected void initTransactionManager() {
        if (this.transactionManager == null) {
            if (this.transactionManagerJndiName == null || this.transactionManagerJndiName.isEmpty()) {
                throw LOG.invalidConfigTransactionManagerIsNull();
            }
            try {
                this.transactionManager = (TransactionManager)new InitialContext().lookup(this.transactionManagerJndiName);
            }
            catch (NamingException e) {
                throw LOG.invalidConfigCannotFindTransactionManger(this.transactionManagerJndiName + "'.", e);
            }
        }
    }

    @Override
    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new JakartaTransactionContextFactory(this.transactionManager);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

