/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cfg.auth;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.authorization.HistoricTaskPermissions;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.authorization.TaskPermissions;
import org.operaton.bpm.engine.delegate.DelegateTask;
import org.operaton.bpm.engine.filter.Filter;
import org.operaton.bpm.engine.identity.Group;
import org.operaton.bpm.engine.identity.Tenant;
import org.operaton.bpm.engine.identity.User;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.operaton.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.identity.Authentication;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.repository.DecisionDefinition;
import org.operaton.bpm.engine.repository.DecisionRequirementsDefinition;
import org.operaton.bpm.engine.repository.Deployment;
import org.operaton.bpm.engine.repository.ProcessDefinition;
import org.operaton.bpm.engine.runtime.ProcessInstance;
import org.operaton.bpm.engine.task.Task;

public class DefaultAuthorizationProvider
implements ResourceAuthorizationProvider {
    @Override
    public AuthorizationEntity[] newUser(User user) {
        String userId = user.getId();
        EnsureUtil.ensureValidIndividualResourceId("Cannot create default authorization for user " + userId, userId);
        AuthorizationEntity resourceOwnerAuthorization = this.createGrantAuthorization(userId, null, Resources.USER, userId, Permissions.ALL);
        return new AuthorizationEntity[]{resourceOwnerAuthorization};
    }

    @Override
    public AuthorizationEntity[] newGroup(Group group) {
        ArrayList<AuthorizationEntity> authorizations = new ArrayList<AuthorizationEntity>();
        String groupId = group.getId();
        EnsureUtil.ensureValidIndividualResourceId("Cannot create default authorization for group " + groupId, groupId);
        AuthorizationEntity groupMemberAuthorization = this.createGrantAuthorization(null, groupId, Resources.GROUP, groupId, Permissions.READ);
        authorizations.add(groupMemberAuthorization);
        return authorizations.toArray(new AuthorizationEntity[0]);
    }

    @Override
    public AuthorizationEntity[] newTenant(Tenant tenant) {
        return null;
    }

    @Override
    public AuthorizationEntity[] groupMembershipCreated(String groupId, String userId) {
        return null;
    }

    @Override
    public AuthorizationEntity[] tenantMembershipCreated(Tenant tenant, User user) {
        AuthorizationEntity userAuthorization = this.createGrantAuthorization(user.getId(), null, Resources.TENANT, tenant.getId(), Permissions.READ);
        return new AuthorizationEntity[]{userAuthorization};
    }

    @Override
    public AuthorizationEntity[] tenantMembershipCreated(Tenant tenant, Group group) {
        AuthorizationEntity userAuthorization = this.createGrantAuthorization(null, group.getId(), Resources.TENANT, tenant.getId(), Permissions.READ);
        return new AuthorizationEntity[]{userAuthorization};
    }

    @Override
    public AuthorizationEntity[] newFilter(Filter filter) {
        String owner = filter.getOwner();
        if (owner != null) {
            String filterId = filter.getId();
            EnsureUtil.ensureValidIndividualResourceId("Cannot create default authorization for filter owner " + owner, owner);
            AuthorizationEntity filterOwnerAuthorization = this.createGrantAuthorization(owner, null, Resources.FILTER, filterId, Permissions.ALL);
            return new AuthorizationEntity[]{filterOwnerAuthorization};
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newDeployment(Deployment deployment) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        IdentityService identityService = processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication != null && currentAuthentication.getUserId() != null) {
            String userId = currentAuthentication.getUserId();
            String deploymentId = deployment.getId();
            AuthorizationEntity authorization = this.createGrantAuthorization(userId, null, Resources.DEPLOYMENT, deploymentId, Permissions.READ, Permissions.DELETE);
            return new AuthorizationEntity[]{authorization};
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newProcessDefinition(ProcessDefinition processDefinition) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newProcessInstance(ProcessInstance processInstance) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newTask(Task task) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskAssignee(Task task, String oldAssignee, String newAssignee) {
        if (newAssignee != null) {
            EnsureUtil.ensureValidIndividualResourceId("Cannot create default authorization for assignee " + newAssignee, newAssignee);
            return this.createOrUpdateAuthorizationsByUserId(task, newAssignee);
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskOwner(Task task, String oldOwner, String newOwner) {
        if (newOwner != null) {
            EnsureUtil.ensureValidIndividualResourceId("Cannot create default authorization for owner " + newOwner, newOwner);
            return this.createOrUpdateAuthorizationsByUserId(task, newOwner);
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskUserIdentityLink(Task task, String userId, String type) {
        EnsureUtil.ensureValidIndividualResourceId("Cannot grant default authorization for identity link to user " + userId, userId);
        return this.createOrUpdateAuthorizationsByUserId(task, userId);
    }

    @Override
    public AuthorizationEntity[] newTaskGroupIdentityLink(Task task, String groupId, String type) {
        EnsureUtil.ensureValidIndividualResourceId("Cannot grant default authorization for identity link to group " + groupId, groupId);
        return this.createOrUpdateAuthorizationsByGroupId(task, groupId);
    }

    @Override
    public AuthorizationEntity[] deleteTaskUserIdentityLink(Task task, String userId, String type) {
        return null;
    }

    @Override
    public AuthorizationEntity[] deleteTaskGroupIdentityLink(Task task, String groupId, String type) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newDecisionDefinition(DecisionDefinition decisionDefinition) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newDecisionRequirementsDefinition(DecisionRequirementsDefinition decisionRequirementsDefinition) {
        return null;
    }

    protected AuthorizationEntity[] createOrUpdateAuthorizationsByGroupId(Task task, String groupId) {
        return this.createOrUpdateAuthorizations(task, groupId, null);
    }

    protected AuthorizationEntity[] createOrUpdateAuthorizationsByUserId(Task task, String userId) {
        return this.createOrUpdateAuthorizations(task, null, userId);
    }

    protected AuthorizationEntity[] createOrUpdateAuthorizations(Task task, String groupId, String userId) {
        boolean enforceSpecificVariablePermission = this.isEnforceSpecificVariablePermission();
        Permission[] runtimeTaskPermissions = this.getRuntimePermissions(enforceSpecificVariablePermission);
        AuthorizationEntity runtimeAuthorization = this.createOrUpdateAuthorization(task, userId, groupId, Resources.TASK, false, runtimeTaskPermissions);
        if (!this.isHistoricInstancePermissionsEnabled()) {
            return new AuthorizationEntity[]{runtimeAuthorization};
        }
        Permission[] historicTaskPermissions = this.getHistoricPermissions(enforceSpecificVariablePermission);
        AuthorizationEntity historyAuthorization = this.createOrUpdateAuthorization(task, userId, groupId, Resources.HISTORIC_TASK, true, historicTaskPermissions);
        return new AuthorizationEntity[]{runtimeAuthorization, historyAuthorization};
    }

    protected AuthorizationEntity createOrUpdateAuthorization(Task task, String userId, String groupId, Resource resource, boolean isHistoric, Permission ... permissions) {
        String taskId = task.getId();
        AuthorizationEntity authorization = this.getGrantAuthorization(taskId, userId, groupId, resource);
        if (authorization == null) {
            authorization = this.createAuthorization(userId, groupId, resource, taskId, permissions);
            if (isHistoric) {
                this.provideRemovalTime(authorization, task);
            }
        } else {
            this.addPermissions(authorization, permissions);
        }
        return authorization;
    }

    protected void provideRemovalTime(AuthorizationEntity authorization, Task task) {
        String rootProcessInstanceId = this.getRootProcessInstanceId(task);
        if (rootProcessInstanceId != null) {
            authorization.setRootProcessInstanceId(rootProcessInstanceId);
            if (this.isHistoryRemovalTimeStrategyStart()) {
                HistoryEvent rootProcessInstance = this.findHistoricProcessInstance(rootProcessInstanceId);
                Date removalTime = null;
                if (rootProcessInstance != null) {
                    removalTime = rootProcessInstance.getRemovalTime();
                }
                authorization.setRemovalTime(removalTime);
            }
        }
    }

    protected String getRootProcessInstanceId(Task task) {
        ExecutionEntity execution = (ExecutionEntity)((DelegateTask)((Object)task)).getExecution();
        if (execution != null) {
            return execution.getRootProcessInstanceId();
        }
        return null;
    }

    protected boolean isHistoryRemovalTimeStrategyStart() {
        return "start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected HistoryEvent findHistoricProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected Permission[] getHistoricPermissions(boolean enforceSpecificVariablePermission) {
        ArrayList<HistoricTaskPermissions> historicPermissions = new ArrayList<HistoricTaskPermissions>();
        historicPermissions.add(HistoricTaskPermissions.READ);
        if (enforceSpecificVariablePermission) {
            historicPermissions.add(HistoricTaskPermissions.READ_VARIABLE);
        }
        return historicPermissions.toArray(new Permission[0]);
    }

    protected Permission[] getRuntimePermissions(boolean enforceSpecificVariablePermission) {
        ArrayList<Permission> runtimePermissions = new ArrayList<Permission>();
        runtimePermissions.add(Permissions.READ);
        Permission defaultUserPermissionForTask = this.getDefaultUserPermissionForTask();
        runtimePermissions.add(defaultUserPermissionForTask);
        if (enforceSpecificVariablePermission) {
            runtimePermissions.add(TaskPermissions.READ_VARIABLE);
        }
        return runtimePermissions.toArray(new Permission[0]);
    }

    protected boolean isHistoricInstancePermissionsEnabled() {
        return Context.getProcessEngineConfiguration().isEnableHistoricInstancePermissions();
    }

    protected AuthorizationManager getAuthorizationManager() {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getAuthorizationManager();
    }

    protected AuthorizationEntity getGrantAuthorization(String taskId, String userId, String groupId, Resource resource) {
        if (groupId != null) {
            return this.getGrantAuthorizationByGroupId(groupId, resource, taskId);
        }
        return this.getGrantAuthorizationByUserId(userId, resource, taskId);
    }

    protected AuthorizationEntity getGrantAuthorizationByUserId(String userId, Resource resource, String resourceId) {
        AuthorizationManager authorizationManager = this.getAuthorizationManager();
        return authorizationManager.findAuthorizationByUserIdAndResourceId(1, userId, resource, resourceId);
    }

    protected AuthorizationEntity getGrantAuthorizationByGroupId(String groupId, Resource resource, String resourceId) {
        AuthorizationManager authorizationManager = this.getAuthorizationManager();
        return authorizationManager.findAuthorizationByGroupIdAndResourceId(1, groupId, resource, resourceId);
    }

    protected AuthorizationEntity createAuthorization(String userId, String groupId, Resource resource, String resourceId, Permission ... permissions) {
        AuthorizationEntity authorization = this.createGrantAuthorization(userId, groupId, resource, resourceId, permissions);
        this.updateAuthorizationBasedOnCacheEntries(authorization, userId, groupId, resource, resourceId);
        return authorization;
    }

    protected void addPermissions(AuthorizationEntity authorization, Permission ... permissions) {
        if (permissions != null) {
            for (Permission permission : permissions) {
                if (permission == null) continue;
                authorization.addPermission(permission);
            }
        }
    }

    protected AuthorizationEntity createGrantAuthorization(String userId, String groupId, Resource resource, String resourceId, Permission ... permissions) {
        if (userId != null) {
            EnsureUtil.ensureValidIndividualResourceId("Cannot create authorization for user " + userId, userId);
        }
        if (groupId != null) {
            EnsureUtil.ensureValidIndividualResourceId("Cannot create authorization for group " + groupId, groupId);
        }
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setUserId(userId);
        authorization.setGroupId(groupId);
        authorization.setResource(resource);
        authorization.setResourceId(resourceId);
        this.addPermissions(authorization, permissions);
        return authorization;
    }

    protected Permission getDefaultUserPermissionForTask() {
        return Context.getProcessEngineConfiguration().getDefaultUserPermissionForTask();
    }

    protected boolean isEnforceSpecificVariablePermission() {
        return Context.getProcessEngineConfiguration().isEnforceSpecificVariablePermission();
    }

    protected void updateAuthorizationBasedOnCacheEntries(AuthorizationEntity authorization, String userId, String groupId, Resource resource, String resourceId) {
        DbEntityManager dbManager = Context.getCommandContext().getDbEntityManager();
        List<AuthorizationEntity> list = dbManager.getCachedEntitiesByType(AuthorizationEntity.class);
        for (AuthorizationEntity authEntity : list) {
            boolean hasSameAuthRights = this.hasEntitySameAuthorizationRights(authEntity, userId, groupId, resource, resourceId);
            if (!hasSameAuthRights) continue;
            int previousPermissions = authEntity.getPermissions();
            authorization.setPermissions(previousPermissions);
            dbManager.getDbEntityCache().remove(authEntity);
            return;
        }
    }

    protected boolean hasEntitySameAuthorizationRights(AuthorizationEntity authEntity, String userId, String groupId, Resource resource, String resourceId) {
        boolean sameUserId = this.areIdsEqual(authEntity.getUserId(), userId);
        boolean sameGroupId = this.areIdsEqual(authEntity.getGroupId(), groupId);
        boolean sameResourceId = this.areIdsEqual(authEntity.getResourceId(), resourceId);
        boolean sameResourceType = authEntity.getResourceType() == resource.resourceType();
        boolean sameAuthorizationType = authEntity.getAuthorizationType() == 1;
        return sameUserId && sameGroupId && sameResourceType && sameResourceId && sameAuthorizationType;
    }

    protected boolean areIdsEqual(String firstId, String secondId) {
        return Objects.equals(firstId, secondId);
    }
}

