/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.operaton.bpm.engine.impl.core.model.CoreModelElement;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.process.TransitionImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class ActivityAfterInstantiationCmd
extends AbstractInstantiationCmd {
    protected String activityId;

    public ActivityAfterInstantiationCmd(String activityId) {
        this(null, activityId);
    }

    public ActivityAfterInstantiationCmd(String processInstanceId, String activityId) {
        this(processInstanceId, activityId, null);
    }

    public ActivityAfterInstantiationCmd(String processInstanceId, String activityId, String ancestorActivityInstanceId) {
        super(processInstanceId, ancestorActivityInstanceId);
        this.activityId = activityId;
    }

    @Override
    protected ScopeImpl getTargetFlowScope(ProcessDefinitionImpl processDefinition) {
        TransitionImpl transition = this.findTransition(processDefinition);
        return transition.getDestination().getFlowScope();
    }

    @Override
    protected CoreModelElement getTargetElement(ProcessDefinitionImpl processDefinition) {
        return this.findTransition(processDefinition);
    }

    protected TransitionImpl findTransition(ProcessDefinitionImpl processDefinition) {
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Activity '" + this.activityId + "' does not exist"), "activity", (Object)activity);
        if (activity.getOutgoingTransitions().isEmpty()) {
            throw new ProcessEngineException("Cannot start after activity " + this.activityId + "; activity has no outgoing sequence flow to take");
        }
        if (activity.getOutgoingTransitions().size() > 1) {
            throw new ProcessEngineException("Cannot start after activity " + this.activityId + "; activity has more than one outgoing sequence flow");
        }
        return (TransitionImpl)activity.getOutgoingTransitions().get(0);
    }

    @Override
    public String getTargetElementId() {
        return this.activityId;
    }

    @Override
    protected String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("Start after activity '");
        sb.append(this.activityId);
        sb.append("'");
        if (this.ancestorActivityInstanceId != null) {
            sb.append(" with ancestor activity instance '");
            sb.append(this.ancestorActivityInstanceId);
            sb.append("'");
        }
        return sb.toString();
    }
}

