/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.List;
import org.operaton.bpm.engine.MismatchingMessageCorrelationException;
import org.operaton.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.runtime.CorrelationHandler;
import org.operaton.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.operaton.bpm.engine.impl.runtime.CorrelationSet;
import org.operaton.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<MessageCorrelationResultImpl> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected boolean startMessageOnly;

    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl, boolean collectVariables, boolean deserializeVariableValues, boolean startMessageOnly) {
        super(messageCorrelationBuilderImpl, collectVariables, deserializeVariableValues);
        this.startMessageOnly = startMessageOnly;
    }

    @Override
    public MessageCorrelationResultImpl execute(CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        CorrelationSet correlationSet = new CorrelationSet(this.builder);
        CorrelationHandlerResult correlationResult = null;
        if (this.startMessageOnly) {
            List correlationResults = commandContext.runWithoutAuthorization(() -> correlationHandler.correlateStartMessages(commandContext, this.messageName, correlationSet));
            if (correlationResults.isEmpty()) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition matches the parameters");
            }
            if (correlationResults.size() > 1) {
                throw LOG.exceptionCorrelateMessageToSingleProcessDefinition(this.messageName, correlationResults.size(), correlationSet);
            }
            correlationResult = (CorrelationHandlerResult)correlationResults.get(0);
        } else {
            correlationResult = commandContext.runWithoutAuthorization(() -> correlationHandler.correlateMessage(commandContext, this.messageName, correlationSet));
            if (correlationResult == null) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
            }
        }
        this.checkAuthorization(correlationResult);
        return this.createMessageCorrelationResult(commandContext, correlationResult);
    }
}

