/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.core.variable.VariableUtil;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.migration.MigrationInstructionGenerator;
import org.operaton.bpm.engine.impl.migration.MigrationLogger;
import org.operaton.bpm.engine.impl.migration.MigrationPlanBuilderImpl;
import org.operaton.bpm.engine.impl.migration.MigrationPlanImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationPlanValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationVariableValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructionImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.migration.MigrationInstruction;
import org.operaton.bpm.engine.migration.MigrationPlan;
import org.operaton.bpm.engine.variable.VariableMap;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class CreateMigrationPlanCmd
implements Command<MigrationPlan> {
    public static final MigrationLogger LOG = ProcessEngineLogger.MIGRATION_LOGGER;
    protected MigrationPlanBuilderImpl migrationBuilder;

    public CreateMigrationPlanCmd(MigrationPlanBuilderImpl migrationPlanBuilderImpl) {
        this.migrationBuilder = migrationPlanBuilderImpl;
    }

    @Override
    public MigrationPlan execute(CommandContext commandContext) {
        ProcessDefinitionEntity sourceProcessDefinition = this.getProcessDefinition(commandContext, this.migrationBuilder.getSourceProcessDefinitionId(), "Source");
        ProcessDefinitionEntity targetProcessDefinition = this.getProcessDefinition(commandContext, this.migrationBuilder.getTargetProcessDefinitionId(), "Target");
        this.checkAuthorization(commandContext, sourceProcessDefinition, targetProcessDefinition);
        MigrationPlanImpl migrationPlan = new MigrationPlanImpl(sourceProcessDefinition.getId(), targetProcessDefinition.getId());
        ArrayList<MigrationInstruction> instructions = new ArrayList<MigrationInstruction>();
        if (this.migrationBuilder.isMapEqualActivities()) {
            instructions.addAll(this.generateInstructions(commandContext, sourceProcessDefinition, targetProcessDefinition, this.migrationBuilder.isUpdateEventTriggersForGeneratedInstructions()));
        }
        instructions.addAll(this.migrationBuilder.getExplicitMigrationInstructions());
        migrationPlan.setInstructions(instructions);
        VariableMap variables = this.migrationBuilder.getVariables();
        if (variables != null) {
            migrationPlan.setVariables(variables);
        }
        this.validateMigration(commandContext, migrationPlan, sourceProcessDefinition, targetProcessDefinition);
        return migrationPlan;
    }

    protected void validateMigration(CommandContext commandContext, MigrationPlanImpl migrationPlan, ProcessDefinitionEntity sourceProcessDefinition, ProcessDefinitionEntity targetProcessDefinition) {
        MigrationPlanValidationReportImpl planReport = new MigrationPlanValidationReportImpl(migrationPlan);
        VariableMap variables = migrationPlan.getVariables();
        if (variables != null) {
            this.validateVariables(variables, planReport);
        }
        this.validateMigrationInstructions(commandContext, planReport, migrationPlan, sourceProcessDefinition, targetProcessDefinition);
        if (planReport.hasReports()) {
            throw LOG.failingMigrationPlanValidation(planReport);
        }
    }

    protected void validateVariables(VariableMap variables, MigrationPlanValidationReportImpl planReport) {
        variables.keySet().forEach(name -> {
            TypedValue valueTyped = variables.getValueTyped(name);
            boolean javaSerializationProhibited = VariableUtil.isJavaSerializationProhibited(valueTyped);
            if (javaSerializationProhibited) {
                MigrationVariableValidationReportImpl report = new MigrationVariableValidationReportImpl(valueTyped);
                String failureMessage = MessageFormat.format("Cannot set variable with name {0}. Java serialization format is prohibited", name);
                report.addFailure(failureMessage);
                planReport.addVariableReport((String)name, report);
            }
        });
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String id, String type) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, type + " process definition id", (Object)id);
        try {
            return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(id);
        }
        catch (NotFoundException e) {
            throw LOG.processDefinitionDoesNotExist(id, type);
        }
    }

    protected void checkAuthorization(CommandContext commandContext, ProcessDefinitionEntity sourceProcessDefinition, ProcessDefinitionEntity targetProcessDefinition) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateMigrationPlan(sourceProcessDefinition, targetProcessDefinition);
        }
    }

    protected List<MigrationInstruction> generateInstructions(CommandContext commandContext, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, boolean updateEventTriggers) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        MigrationInstructionGenerator migrationInstructionGenerator = processEngineConfiguration.getMigrationInstructionGenerator();
        ValidatingMigrationInstructions generatedInstructions = migrationInstructionGenerator.generate(sourceProcessDefinition, targetProcessDefinition, updateEventTriggers);
        generatedInstructions.filterWith(processEngineConfiguration.getMigrationInstructionValidators());
        return generatedInstructions.asMigrationInstructions();
    }

    protected void validateMigrationInstructions(CommandContext commandContext, MigrationPlanValidationReportImpl planReport, MigrationPlanImpl migrationPlan, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition) {
        List<MigrationInstructionValidator> migrationInstructionValidators = commandContext.getProcessEngineConfiguration().getMigrationInstructionValidators();
        ValidatingMigrationInstructions validatingMigrationInstructions = this.wrapMigrationInstructions(migrationPlan, sourceProcessDefinition, targetProcessDefinition, planReport);
        for (ValidatingMigrationInstruction validatingMigrationInstruction : validatingMigrationInstructions.getInstructions()) {
            MigrationInstructionValidationReportImpl instructionReport = this.validateInstruction(validatingMigrationInstruction, validatingMigrationInstructions, migrationInstructionValidators);
            if (!instructionReport.hasFailures()) continue;
            planReport.addInstructionReport(instructionReport);
        }
    }

    protected MigrationInstructionValidationReportImpl validateInstruction(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, List<MigrationInstructionValidator> migrationInstructionValidators) {
        MigrationInstructionValidationReportImpl validationReport = new MigrationInstructionValidationReportImpl(instruction.toMigrationInstruction());
        for (MigrationInstructionValidator migrationInstructionValidator : migrationInstructionValidators) {
            migrationInstructionValidator.validate(instruction, instructions, validationReport);
        }
        return validationReport;
    }

    protected ValidatingMigrationInstructions wrapMigrationInstructions(MigrationPlan migrationPlan, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, MigrationPlanValidationReportImpl planReport) {
        ValidatingMigrationInstructions validatingMigrationInstructions = new ValidatingMigrationInstructions();
        for (MigrationInstruction migrationInstruction : migrationPlan.getInstructions()) {
            MigrationInstructionValidationReportImpl instructionReport = new MigrationInstructionValidationReportImpl(migrationInstruction);
            String sourceActivityId = migrationInstruction.getSourceActivityId();
            String targetActivityId = migrationInstruction.getTargetActivityId();
            if (sourceActivityId != null && targetActivityId != null) {
                ActivityImpl sourceActivity = sourceProcessDefinition.findActivity(sourceActivityId);
                ActivityImpl targetActivity = targetProcessDefinition.findActivity(migrationInstruction.getTargetActivityId());
                if (sourceActivity != null && targetActivity != null) {
                    validatingMigrationInstructions.addInstruction(new ValidatingMigrationInstructionImpl(sourceActivity, targetActivity, migrationInstruction.isUpdateEventTrigger()));
                } else {
                    if (sourceActivity == null) {
                        instructionReport.addFailure("Source activity '" + sourceActivityId + "' does not exist");
                    }
                    if (targetActivity == null) {
                        instructionReport.addFailure("Target activity '" + targetActivityId + "' does not exist");
                    }
                }
            } else {
                if (sourceActivityId == null) {
                    instructionReport.addFailure("Source activity id is null");
                }
                if (targetActivityId == null) {
                    instructionReport.addFailure("Target activity id is null");
                }
            }
            if (!instructionReport.hasFailures()) continue;
            planReport.addInstructionReport(instructionReport);
        }
        return validatingMigrationInstructions;
    }
}

