/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.impl.AuthorizationQueryImpl;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class DeleteAuthorizationCmd
implements Command<Void> {
    protected String authorizationId;

    public DeleteAuthorizationCmd(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        AuthorizationEntity authorization = (AuthorizationEntity)new AuthorizationQueryImpl().authorizationId(this.authorizationId).singleResult();
        EnsureUtil.ensureNotNull("Authorization for Id '" + this.authorizationId + "' does not exist", "authorization", (Object)authorization);
        authorizationManager.delete(authorization);
        commandContext.getOperationLogManager().logAuthorizationOperation("Delete", authorization, null);
        return null;
    }
}

