/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.deploy.Deployer;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.repository.ProcessDefinition;

public class DeleteProcessDefinitionsByIdsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<String> processDefinitionIds;
    protected boolean cascadeToHistory;
    protected boolean cascadeToInstances;
    protected boolean skipCustomListeners;
    protected boolean writeUserOperationLog;
    protected boolean skipIoMappings;

    public DeleteProcessDefinitionsByIdsCmd(List<String> processDefinitionIds, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        this(processDefinitionIds, cascade, cascade, skipCustomListeners, skipIoMappings, true);
    }

    public DeleteProcessDefinitionsByIdsCmd(List<String> processDefinitionIds, boolean cascadeToHistory, boolean cascadeToInstances, boolean skipCustomListeners, boolean writeUserOperationLog) {
        this(processDefinitionIds, cascadeToHistory, cascadeToInstances, skipCustomListeners, false, writeUserOperationLog);
    }

    public DeleteProcessDefinitionsByIdsCmd(List<String> processDefinitionIds, boolean cascadeToHistory, boolean cascadeToInstances, boolean skipCustomListeners, boolean skipIoMappings, boolean writeUserOperationLog) {
        this.processDefinitionIds = new HashSet<String>(processDefinitionIds);
        this.cascadeToHistory = cascadeToHistory;
        this.cascadeToInstances = cascadeToInstances;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
        this.writeUserOperationLog = writeUserOperationLog;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<Object> processDefinitions;
        EnsureUtil.ensureNotNull("processDefinitionIds", this.processDefinitionIds);
        if (this.processDefinitionIds.size() == 1) {
            ProcessDefinition processDefinition = this.getSingleProcessDefinition(commandContext);
            processDefinitions = new ArrayList();
            processDefinitions.add(processDefinition);
        } else {
            ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
            processDefinitions = processDefinitionManager.findDefinitionsByIds(this.processDefinitionIds);
            EnsureUtil.ensureNotEmpty(NotFoundException.class, "No process definition found", "processDefinitions", processDefinitions);
        }
        Set<ProcessDefinitionGroup> groups = this.groupByKeyAndTenant(processDefinitions);
        for (ProcessDefinitionGroup group : groups) {
            this.checkAuthorization(group);
        }
        for (ProcessDefinitionGroup group : groups) {
            this.deleteProcessDefinitions(group);
        }
        return null;
    }

    protected ProcessDefinition getSingleProcessDefinition(CommandContext commandContext) {
        String processDefinitionId = this.processDefinitionIds.iterator().next();
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        return processDefinition;
    }

    protected Set<ProcessDefinitionGroup> groupByKeyAndTenant(List<ProcessDefinition> processDefinitions) {
        HashSet<ProcessDefinitionGroup> groups = new HashSet<ProcessDefinitionGroup>();
        HashMap<ProcessDefinitionGroup, List> map = new HashMap<ProcessDefinitionGroup, List>();
        for (ProcessDefinition current : processDefinitions) {
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)current;
            ProcessDefinitionGroup group = new ProcessDefinitionGroup();
            group.key = processDefinition.getKey();
            group.tenant = processDefinition.getTenantId();
            List definitions = group.processDefinitions;
            if (map.containsKey(group)) {
                definitions = (List)map.get(group);
            } else {
                groups.add(group);
                map.put(group, definitions);
            }
            definitions.add(processDefinition);
        }
        return groups;
    }

    protected ProcessDefinitionEntity findNewLatestProcessDefinition(ProcessDefinitionGroup group) {
        ProcessDefinitionEntity newLatestProcessDefinition = null;
        List<ProcessDefinitionEntity> processDefinitions = group.processDefinitions;
        ProcessDefinitionEntity firstProcessDefinition = processDefinitions.get(0);
        if (this.isLatestProcessDefinition(firstProcessDefinition)) {
            for (ProcessDefinitionEntity processDefinition : processDefinitions) {
                String previousProcessDefinitionId = processDefinition.getPreviousProcessDefinitionId();
                if (previousProcessDefinitionId == null || this.processDefinitionIds.contains(previousProcessDefinitionId)) continue;
                CommandContext commandContext = Context.getCommandContext();
                ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
                newLatestProcessDefinition = processDefinitionManager.findLatestDefinitionById(previousProcessDefinitionId);
                break;
            }
        }
        return newLatestProcessDefinition;
    }

    protected boolean isLatestProcessDefinition(ProcessDefinitionEntity processDefinition) {
        ProcessDefinitionManager processDefinitionManager = Context.getCommandContext().getProcessDefinitionManager();
        String key = processDefinition.getKey();
        String tenantId = processDefinition.getTenantId();
        ProcessDefinitionEntity latestProcessDefinition = processDefinitionManager.findLatestDefinitionByKeyAndTenantId(key, tenantId);
        return processDefinition.getId().equals(latestProcessDefinition.getId());
    }

    protected void checkAuthorization(ProcessDefinitionGroup group) {
        List<CommandChecker> commandCheckers = Context.getCommandContext().getProcessEngineConfiguration().getCommandCheckers();
        List<ProcessDefinitionEntity> processDefinitions = group.processDefinitions;
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            for (CommandChecker commandChecker : commandCheckers) {
                commandChecker.checkDeleteProcessDefinitionById(processDefinition.getId());
            }
        }
    }

    protected void deleteProcessDefinitions(ProcessDefinitionGroup group) {
        ProcessDefinitionEntity newLatestProcessDefinition = this.findNewLatestProcessDefinition(group);
        CommandContext commandContext = Context.getCommandContext();
        UserOperationLogManager userOperationLogManager = commandContext.getOperationLogManager();
        ProcessDefinitionManager definitionManager = commandContext.getProcessDefinitionManager();
        List<ProcessDefinitionEntity> processDefinitions = group.processDefinitions;
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            String processDefinitionId = processDefinition.getId();
            if (this.writeUserOperationLog) {
                userOperationLogManager.logProcessDefinitionOperation("Delete", processDefinitionId, processDefinition.getKey(), new PropertyChange("cascade", false, this.cascadeToHistory));
            }
            definitionManager.deleteProcessDefinition(processDefinition, processDefinitionId, this.cascadeToHistory, this.cascadeToInstances, this.skipCustomListeners, this.skipIoMappings);
        }
        if (newLatestProcessDefinition != null) {
            ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
            DeploymentCache deploymentCache = configuration.getDeploymentCache();
            newLatestProcessDefinition = deploymentCache.resolveProcessDefinition(newLatestProcessDefinition);
            List<Deployer> deployers = configuration.getDeployers();
            for (Deployer deployer : deployers) {
                if (!(deployer instanceof BpmnDeployer)) continue;
                BpmnDeployer bpmnDeployer = (BpmnDeployer)deployer;
                bpmnDeployer.addEventSubscriptions(newLatestProcessDefinition);
                bpmnDeployer.addTimerDeclarations(newLatestProcessDefinition);
            }
        }
    }

    private static class ProcessDefinitionGroup {
        String key;
        String tenant;
        List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();

        private ProcessDefinitionGroup() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessDefinitionGroup other = (ProcessDefinitionGroup)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
        }
    }
}

