/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class FindActiveActivityIdsCmd
implements Command<List<String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public FindActiveActivityIdsCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public List<String> execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull("execution " + this.executionId + " doesn't exist", "execution", (Object)execution);
        this.checkGetActivityIds(execution, commandContext);
        return execution.findActiveActivityIds();
    }

    protected void checkGetActivityIds(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstance(execution);
        }
    }
}

