/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class GetExternalTaskErrorDetailsCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String externalTaskId;

    public GetExternalTaskErrorDetailsCmd(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull("No external task found with id " + this.externalTaskId, "externalTask", (Object)externalTask);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstance(externalTask.getProcessInstanceId());
        }
        return externalTask.getErrorDetails();
    }
}

