/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;

    public GetJobExceptionStacktraceCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull("No job found with id " + this.jobId, "job", (Object)job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadJob(job);
        }
        return job.getExceptionStacktrace();
    }
}

