/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.operaton.bpm.engine.AuthorizationException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.operaton.bpm.engine.impl.core.model.CallableElement;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.repository.CalledProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.util.CallableElementUtil;
import org.operaton.bpm.engine.repository.CalledProcessDefinition;
import org.operaton.bpm.engine.repository.ProcessDefinition;

public class GetStaticCalledProcessDefinitionCmd
implements Command<Collection<CalledProcessDefinition>> {
    protected String processDefinitionId;

    public GetStaticCalledProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    protected List<ActivityImpl> findCallActivitiesInProcess(ProcessDefinitionEntity processDefinition) {
        ArrayList<ActivityImpl> callActivities = new ArrayList<ActivityImpl>();
        LinkedList<ActivityImpl> toCheck = new LinkedList<ActivityImpl>(processDefinition.getActivities());
        while (!toCheck.isEmpty()) {
            ActivityImpl candidate = (ActivityImpl)toCheck.poll();
            if (!candidate.getActivities().isEmpty()) {
                toCheck.addAll(candidate.getActivities());
            }
            if (!(candidate.getActivityBehavior() instanceof CallActivityBehavior)) continue;
            callActivities.add(candidate);
        }
        return callActivities;
    }

    @Override
    public Collection<CalledProcessDefinition> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.processDefinitionId, true).execute(commandContext);
        List<ActivityImpl> callActivities = this.findCallActivitiesInProcess(processDefinition);
        HashMap<String, CalledProcessDefinitionImpl> calledProcessDefinitionsById = new HashMap<String, CalledProcessDefinitionImpl>();
        for (ActivityImpl activity : callActivities) {
            String tenantId;
            CallActivityBehavior behavior = (CallActivityBehavior)activity.getActivityBehavior();
            CallableElement callableElement = behavior.getCallableElement();
            String activityId = activity.getActivityId();
            ProcessDefinition calledProcess = CallableElementUtil.getStaticallyBoundProcessDefinition(this.processDefinitionId, activityId, callableElement, tenantId = processDefinition.getTenantId());
            if (calledProcess == null) continue;
            if (!calledProcessDefinitionsById.containsKey(calledProcess.getId())) {
                try {
                    for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                        checker.checkReadProcessDefinition(calledProcess);
                    }
                    CalledProcessDefinitionImpl result = new CalledProcessDefinitionImpl(calledProcess, this.processDefinitionId);
                    result.addCallingCallActivity(activityId);
                    calledProcessDefinitionsById.put(calledProcess.getId(), result);
                }
                catch (AuthorizationException e) {
                    ProcessEngineLogger.CMD_LOGGER.debugNotAllowedToResolveCalledProcess(calledProcess.getId(), this.processDefinitionId, activityId, e);
                }
                continue;
            }
            ((CalledProcessDefinitionImpl)calledProcessDefinitionsById.get(calledProcess.getId())).addCallingCallActivity(activityId);
        }
        return new ArrayList<CalledProcessDefinition>(calledProcessDefinitionsById.values());
    }
}

