/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Date;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.operaton.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class LockExternalTaskCmd
extends HandleExternalTaskCmd {
    protected long lockDuration;

    public LockExternalTaskCmd(String externalTaskId, String workerId, long lockDuration) {
        super(externalTaskId, workerId);
        this.lockDuration = lockDuration;
    }

    @Override
    protected void execute(ExternalTaskEntity externalTask) {
        externalTask.lock(this.workerId, this.lockDuration);
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "External Task " + this.externalTaskId + " cannot be locked by worker '" + this.workerId;
    }

    @Override
    protected boolean validateWorkerViolation(ExternalTaskEntity externalTask) {
        String existingWorkerId = externalTask.getWorkerId();
        Date existingLockExpirationTime = externalTask.getLockExpirationTime();
        boolean workerValidation = existingWorkerId != null && !this.workerId.equals(existingWorkerId);
        boolean lockValidation = existingLockExpirationTime != null && !ClockUtil.getCurrentTime().after(existingLockExpirationTime);
        return workerValidation && lockValidation;
    }

    @Override
    protected void validateInput() {
        super.validateInput();
        EnsureUtil.ensurePositive(BadUserRequestException.class, "lockDuration", (Long)this.lockDuration);
    }
}

