/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.operaton.bpm.engine.identity.Tenant;
import org.operaton.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import org.operaton.bpm.engine.impl.identity.IdentityOperationResult;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SaveTenantCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Tenant tenant;

    public SaveTenantCmd(Tenant tenant) {
        this.tenant = tenant;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("tenant", (Object)this.tenant);
        EnsureUtil.ensureWhitelistedResourceId(commandContext, "Tenant", this.tenant.getId());
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().saveTenant(this.tenant);
        commandContext.getOperationLogManager().logTenantOperation(operationResult, this.tenant.getId());
        return null;
    }
}

