/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.operaton.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.operaton.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.operaton.bpm.engine.impl.core.model.CoreModelElement;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.pvm.process.TransitionImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.operaton.bpm.engine.variable.VariableMap;

public class StartProcessInstanceAtActivitiesCmd
implements Command<ProcessInstanceWithVariables> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstantiationBuilderImpl instantiationBuilder;

    public StartProcessInstanceAtActivitiesCmd(ProcessInstantiationBuilderImpl instantiationBuilder) {
        this.instantiationBuilder = instantiationBuilder;
    }

    @Override
    public ProcessInstanceWithVariables execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.instantiationBuilder, false).execute(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateProcessInstance(processDefinition);
        }
        ProcessInstanceModificationBuilderImpl modificationBuilder = this.instantiationBuilder.getModificationBuilder();
        EnsureUtil.ensureNotEmpty("At least one instantiation instruction required (e.g. by invoking startBefore(..), startAfter(..) or startTransition(..))", "instructions", modificationBuilder.getModificationOperations());
        ActivityImpl initialActivity = this.determineFirstActivity(processDefinition, modificationBuilder);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.instantiationBuilder.getBusinessKey(), this.instantiationBuilder.getCaseInstanceId(), initialActivity);
        if (this.instantiationBuilder.getTenantId() != null) {
            processInstance.setTenantId(this.instantiationBuilder.getTenantId());
        }
        processInstance.setRestartedProcessInstanceId(this.instantiationBuilder.getRestartedProcessInstanceId());
        processInstance.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
        VariableMap variables = modificationBuilder.getProcessVariables();
        ExecutionVariableSnapshotObserver variablesListener = new ExecutionVariableSnapshotObserver(processInstance);
        processInstance.startWithoutExecuting((Map<String, Object>)variables);
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = modificationBuilder.getModificationOperations();
        processInstance.setStarting(instructions.size() == 1);
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            LOG.debugStartingInstruction(processInstance.getId(), i, instruction.describe());
            instruction.setProcessInstanceId(processInstance.getId());
            instruction.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
            instruction.setSkipIoMappings(modificationBuilder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        if (!processInstance.hasChildren() && processInstance.isEnded()) {
            processInstance.propagateEnd();
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Create", processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getProcessDefinition().getKey(), Collections.singletonList(PropertyChange.EMPTY_CHANGE), modificationBuilder.getAnnotation());
        return new ProcessInstanceWithVariablesImpl(processInstance, variablesListener.getVariables());
    }

    protected ActivityImpl determineFirstActivity(ProcessDefinitionImpl processDefinition, ProcessInstanceModificationBuilderImpl modificationBuilder) {
        AbstractProcessInstanceModificationCommand firstInstruction = modificationBuilder.getModificationOperations().get(0);
        if (firstInstruction instanceof AbstractInstantiationCmd) {
            AbstractInstantiationCmd instantiationInstruction = (AbstractInstantiationCmd)firstInstruction;
            CoreModelElement targetElement = instantiationInstruction.getTargetElement(processDefinition);
            EnsureUtil.ensureNotNull(NotValidException.class, "Element '" + instantiationInstruction.getTargetElementId() + "' does not exist in process " + processDefinition.getId(), "targetElement", (Object)targetElement);
            if (targetElement instanceof ActivityImpl) {
                ActivityImpl activity = (ActivityImpl)targetElement;
                return activity;
            }
            if (targetElement instanceof TransitionImpl) {
                TransitionImpl transition = (TransitionImpl)targetElement;
                return (ActivityImpl)transition.getDestination();
            }
        }
        return null;
    }
}

