/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.batch.history.HistoricBatch;
import org.operaton.bpm.engine.batch.history.HistoricBatchQuery;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.operaton.bpm.engine.impl.history.SetRemovalTimeToHistoricBatchesBuilderImpl;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricBatchesCmd
implements Command<Batch> {
    protected SetRemovalTimeToHistoricBatchesBuilderImpl builder;

    public SetRemovalTimeToHistoricBatchesCmd(SetRemovalTimeToHistoricBatchesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> instanceIds = this.builder.getIds();
        HistoricBatchQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Neither query nor ids provided.");
        }
        HashSet<String> collectedInstanceIds = new HashSet<String>();
        if (instanceQuery != null) {
            for (HistoricBatch historicBatch : instanceQuery.list()) {
                collectedInstanceIds.add(historicBatch.getId());
            }
        }
        if (instanceIds != null) {
            collectedInstanceIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicBatches", collectedInstanceIds);
        return new BatchBuilder(commandContext).type("batch-set-removal-time").config(this.getConfiguration(collectedInstanceIds)).permission(BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String instanceId : instanceIds) {
            HistoricBatch batch = (HistoricBatch)this.createHistoricBatchQuery(commandContext).batchId(instanceId).singleResult();
            if (batch == null) continue;
            ids.add(batch.getId());
        }
        return ids;
    }

    protected HistoricBatchQuery createHistoricBatchQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricBatchQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)this.builder.getMode()));
        propertyChanges.add(new PropertyChange("removalTime", null, this.builder.getRemovalTime()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logBatchOperation("SetRemovalTime", null, propertyChanges);
    }

    protected boolean hasRemovalTime() {
        return this.builder.getMode() == SetRemovalTimeToHistoricBatchesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricBatchesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    public BatchConfiguration getConfiguration(Collection<String> instances) {
        return new SetRemovalTimeBatchConfiguration(new ArrayList<String>(instances)).setHasRemovalTime(this.hasRemovalTime()).setRemovalTime(this.builder.getRemovalTime());
    }
}

