/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmmn.behavior;

import java.util.Arrays;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.helper.CmmnProperties;
import org.operaton.bpm.engine.impl.cmmn.CaseControlRule;
import org.operaton.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.operaton.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import org.operaton.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.operaton.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.operaton.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class PlanItemDefinitionActivityBehavior
implements CmmnActivityBehavior {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;
    private static final String TRANSITION_CLOSE = "close";

    @Override
    public void execute(CmmnActivityExecution execution) throws Exception {
    }

    protected boolean isAtLeastOneEntryCriterionSatisfied(CmmnActivityExecution execution) {
        if (execution.isEntryCriterionSatisfied()) {
            return true;
        }
        CmmnActivity activity = this.getActivity(execution);
        List<CmmnSentryDeclaration> criteria = activity.getEntryCriteria();
        return criteria == null || criteria.isEmpty();
    }

    protected void evaluateRequiredRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object requiredRule = activity.getProperty("requiredRule");
        if (requiredRule != null) {
            CaseControlRule rule = (CaseControlRule)requiredRule;
            boolean required = rule.evaluate(execution);
            execution.setRequired(required);
        }
    }

    protected boolean evaluateRepetitionRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object repetitionRule = activity.getProperty("repetitionRule");
        if (repetitionRule != null) {
            CaseControlRule rule = (CaseControlRule)repetitionRule;
            return rule.evaluate(execution);
        }
        return false;
    }

    @Override
    public void onCreate(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.NEW, CaseExecutionState.AVAILABLE, "create");
        this.creating(execution);
    }

    protected void creating(CmmnActivityExecution execution) {
    }

    @Override
    public void started(CmmnActivityExecution execution) {
    }

    protected void completing(CmmnActivityExecution execution) {
    }

    protected void manualCompleting(CmmnActivityExecution execution) {
    }

    @Override
    public void onClose(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                throw LOG.alreadyClosedCaseException(TRANSITION_CLOSE, id);
            }
            if (execution.isActive()) {
                throw LOG.wrongCaseStateException(TRANSITION_CLOSE, id, "[completed|terminated|suspended]", "active");
            }
        } else {
            throw LOG.notACaseInstanceException(TRANSITION_CLOSE, id);
        }
    }

    protected void performTerminate(CmmnActivityExecution execution) {
        execution.performTerminate();
    }

    protected void performParentTerminate(CmmnActivityExecution execution) {
        execution.performParentTerminate();
    }

    protected void performExit(CmmnActivityExecution execution) {
        execution.performExit();
    }

    protected void performSuspension(CmmnActivityExecution execution) {
        execution.performSuspension();
    }

    protected void performParentSuspension(CmmnActivityExecution execution) {
        execution.performParentSuspension();
    }

    protected void resuming(CmmnActivityExecution execution) {
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
        if (execution.isAvailable()) {
            this.created(execution);
        }
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
    }

    @Override
    public void repeat(CmmnActivityExecution execution, String standardEvent) {
        CmmnActivity activity = execution.getActivity();
        boolean repeat = false;
        if (activity.getEntryCriteria().isEmpty()) {
            List<String> events = activity.getProperties().get(CmmnProperties.REPEAT_ON_STANDARD_EVENTS);
            if (events != null && events.contains(standardEvent)) {
                repeat = this.evaluateRepetitionRule(execution);
            }
        } else if ("enable".equals(standardEvent) || "start".equals(standardEvent) || "occur".equals(standardEvent)) {
            repeat = this.evaluateRepetitionRule(execution);
        }
        if (repeat) {
            CmmnActivityExecution parent = execution.getParent();
            List<CmmnExecution> children = parent.createChildExecutions(Arrays.asList(activity));
            parent.triggerChildExecutionsLifecycle(children);
        }
    }

    protected void ensureTransitionAllowed(CmmnActivityExecution execution, CaseExecutionState expected, CaseExecutionState target, String transition) {
        String id = execution.getId();
        CaseExecutionState currentState = execution.getCurrentState();
        if (execution.isTerminating() || execution.isSuspending()) {
            currentState = execution.getPreviousState();
        }
        if (target.equals(currentState)) {
            throw LOG.isAlreadyInStateException(transition, id, target);
        }
        if (!expected.equals(currentState)) {
            throw LOG.unexpectedStateException(transition, id, expected, currentState);
        }
    }

    protected void ensureNotCaseInstance(CmmnActivityExecution execution, String transition) {
        if (execution.isCaseInstanceExecution()) {
            String id = execution.getId();
            throw LOG.impossibleTransitionException(transition, id);
        }
    }

    protected CmmnActivity getActivity(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + id + "': has no current activity.", "activity", (Object)activity);
        return activity;
    }
}

