/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmmn.handler;

import org.operaton.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.operaton.bpm.engine.impl.cmmn.behavior.DmnDecisionTaskActivityBehavior;
import org.operaton.bpm.engine.impl.cmmn.handler.CallingTaskItemHandler;
import org.operaton.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.operaton.bpm.engine.impl.core.model.BaseCallableElement;
import org.operaton.bpm.engine.impl.dmn.result.DecisionResultMapper;
import org.operaton.bpm.engine.impl.util.DecisionEvaluationUtil;
import org.operaton.bpm.model.cmmn.instance.CmmnElement;
import org.operaton.bpm.model.cmmn.instance.DecisionRefExpression;
import org.operaton.bpm.model.cmmn.instance.DecisionTask;

public class DecisionTaskItemHandler
extends CallingTaskItemHandler {
    @Override
    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeActivity(element, activity, context);
        this.initializeResultVariable(element, activity, context);
        this.initializeDecisionTableResultMapper(element, activity, context);
    }

    protected void initializeResultVariable(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionTask decisionTask = this.getDefinition(element);
        DmnDecisionTaskActivityBehavior behavior = this.getActivityBehavior(activity);
        String resultVariable = decisionTask.getOperatonResultVariable();
        behavior.setResultVariable(resultVariable);
    }

    protected void initializeDecisionTableResultMapper(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionTask decisionTask = this.getDefinition(element);
        DmnDecisionTaskActivityBehavior behavior = this.getActivityBehavior(activity);
        String mapper = decisionTask.getOperatonMapDecisionResult();
        DecisionResultMapper decisionResultMapper = DecisionEvaluationUtil.getDecisionResultMapperForName(mapper);
        behavior.setDecisionTableResultMapper(decisionResultMapper);
    }

    @Override
    protected BaseCallableElement createCallableElement() {
        return new BaseCallableElement();
    }

    @Override
    protected CmmnActivityBehavior getActivityBehavior() {
        return new DmnDecisionTaskActivityBehavior();
    }

    protected DmnDecisionTaskActivityBehavior getActivityBehavior(CmmnActivity activity) {
        return (DmnDecisionTaskActivityBehavior)activity.getActivityBehavior();
    }

    @Override
    protected String getDefinitionKey(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionRefExpression decisionExpression;
        DecisionTask definition = this.getDefinition(element);
        String decision = definition.getDecision();
        if (decision == null && (decisionExpression = definition.getDecisionExpression()) != null) {
            decision = decisionExpression.getText();
        }
        return decision;
    }

    @Override
    protected String getBinding(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionTask definition = this.getDefinition(element);
        return definition.getOperatonDecisionBinding();
    }

    @Override
    protected String getVersion(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionTask definition = this.getDefinition(element);
        return definition.getOperatonDecisionVersion();
    }

    @Override
    protected String getTenantId(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        DecisionTask definition = this.getDefinition(element);
        return definition.getOperatonDecisionTenantId();
    }

    protected DecisionTask getDefinition(CmmnElement element) {
        return (DecisionTask)super.getDefinition(element);
    }
}

