/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmmn.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.delegate.VariableListener;
import org.operaton.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.operaton.bpm.engine.impl.core.model.CoreActivity;
import org.operaton.bpm.model.cmmn.instance.CmmnElement;

public class CmmnActivity
extends CoreActivity {
    private static final long serialVersionUID = 1L;
    protected List<CmmnActivity> activities = new ArrayList<CmmnActivity>();
    protected Map<String, CmmnActivity> namedActivities = new HashMap<String, CmmnActivity>();
    protected CmmnElement cmmnElement;
    protected CmmnActivityBehavior activityBehavior;
    protected CmmnCaseDefinition caseDefinition;
    protected CmmnActivity parent;
    protected List<CmmnSentryDeclaration> sentries = new ArrayList<CmmnSentryDeclaration>();
    protected Map<String, CmmnSentryDeclaration> sentryMap = new HashMap<String, CmmnSentryDeclaration>();
    protected List<CmmnSentryDeclaration> entryCriteria = new ArrayList<CmmnSentryDeclaration>();
    protected List<CmmnSentryDeclaration> exitCriteria = new ArrayList<CmmnSentryDeclaration>();
    protected Map<String, Map<String, List<VariableListener<?>>>> resolvedVariableListeners;
    protected Map<String, Map<String, List<VariableListener<?>>>> resolvedBuiltInVariableListeners;

    public CmmnActivity(String id, CmmnCaseDefinition caseDefinition) {
        super(id);
        this.caseDefinition = caseDefinition;
    }

    @Override
    public CmmnActivity createActivity(String activityId) {
        CmmnActivity activity = new CmmnActivity(activityId, this.caseDefinition);
        if (activityId != null) {
            this.namedActivities.put(activityId, activity);
        }
        activity.setParent(this);
        this.activities.add(activity);
        return activity;
    }

    public List<CmmnActivity> getActivities() {
        return this.activities;
    }

    @Override
    public CmmnActivity findActivity(String activityId) {
        return (CmmnActivity)super.findActivity(activityId);
    }

    @Override
    public CmmnActivity getChildActivity(String activityId) {
        return this.namedActivities.get(activityId);
    }

    public CmmnActivityBehavior getActivityBehavior() {
        return this.activityBehavior;
    }

    public void setActivityBehavior(CmmnActivityBehavior behavior) {
        this.activityBehavior = behavior;
    }

    public CmmnActivity getParent() {
        return this.parent;
    }

    public void setParent(CmmnActivity parent) {
        this.parent = parent;
    }

    public CmmnCaseDefinition getCaseDefinition() {
        return this.caseDefinition;
    }

    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public CmmnElement getCmmnElement() {
        return this.cmmnElement;
    }

    public void setCmmnElement(CmmnElement cmmnElement) {
        this.cmmnElement = cmmnElement;
    }

    public List<CmmnSentryDeclaration> getSentries() {
        return this.sentries;
    }

    public CmmnSentryDeclaration getSentry(String sentryId) {
        return this.sentryMap.get(sentryId);
    }

    public void addSentry(CmmnSentryDeclaration sentry) {
        this.sentryMap.put(sentry.getId(), sentry);
        this.sentries.add(sentry);
    }

    public List<CmmnSentryDeclaration> getEntryCriteria() {
        return this.entryCriteria;
    }

    public void setEntryCriteria(List<CmmnSentryDeclaration> entryCriteria) {
        this.entryCriteria = entryCriteria;
    }

    public void addEntryCriteria(CmmnSentryDeclaration entryCriteria) {
        this.entryCriteria.add(entryCriteria);
    }

    public List<CmmnSentryDeclaration> getExitCriteria() {
        return this.exitCriteria;
    }

    public void setExitCriteria(List<CmmnSentryDeclaration> exitCriteria) {
        this.exitCriteria = exitCriteria;
    }

    public void addExitCriteria(CmmnSentryDeclaration exitCriteria) {
        this.exitCriteria.add(exitCriteria);
    }

    public Map<String, List<VariableListener<?>>> getVariableListeners(String eventName, boolean includeCustomListeners) {
        Map<String, Map<String, List<VariableListener<?>>>> listenerCache;
        if (includeCustomListeners) {
            if (this.resolvedVariableListeners == null) {
                this.resolvedVariableListeners = new HashMap();
            }
            listenerCache = this.resolvedVariableListeners;
        } else {
            if (this.resolvedBuiltInVariableListeners == null) {
                this.resolvedBuiltInVariableListeners = new HashMap();
            }
            listenerCache = this.resolvedBuiltInVariableListeners;
        }
        Map<String, List<VariableListener<?>>> resolvedListenersForEvent = listenerCache.get(eventName);
        if (resolvedListenersForEvent == null) {
            resolvedListenersForEvent = new HashMap();
            listenerCache.put(eventName, resolvedListenersForEvent);
            for (CmmnActivity currentActivity = this; currentActivity != null; currentActivity = currentActivity.getParent()) {
                List<VariableListener<?>> localListeners = null;
                localListeners = includeCustomListeners ? currentActivity.getVariableListenersLocal(eventName) : currentActivity.getBuiltInVariableListenersLocal(eventName);
                if (localListeners == null || localListeners.isEmpty()) continue;
                resolvedListenersForEvent.put(currentActivity.getId(), localListeners);
            }
        }
        return resolvedListenersForEvent;
    }
}

