/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.core.variable.scope;

import jakarta.el.ELContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.operaton.bpm.engine.impl.core.variable.VariableUtil;
import org.operaton.bpm.engine.impl.core.variable.event.VariableEvent;
import org.operaton.bpm.engine.impl.core.variable.event.VariableEventDispatcher;
import org.operaton.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.operaton.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.operaton.bpm.engine.impl.core.variable.scope.VariableStore;
import org.operaton.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.impl.VariableMapImpl;
import org.operaton.bpm.engine.variable.value.TypedValue;

public abstract class AbstractVariableScope
implements Serializable,
VariableScope,
VariableEventDispatcher {
    private static final long serialVersionUID = 1L;
    protected ELContext cachedElContext;

    protected abstract VariableStore<CoreVariableInstance> getVariableStore();

    protected abstract VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory();

    protected abstract List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners();

    public abstract AbstractVariableScope getParentVariableScope();

    public void initializeVariableStore(Map<String, Object> variables) {
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String variableName = entry.getKey();
            TypedValue value = Variables.untypedValue((Object)entry.getValue());
            CoreVariableInstance variableValue = this.getVariableInstanceFactory().build(variableName, value, false);
            this.getVariableStore().addVariable(variableValue);
        }
    }

    @Override
    public String getVariableScopeKey() {
        return "scope";
    }

    public VariableMapImpl getVariables() {
        return this.getVariablesTyped();
    }

    public VariableMapImpl getVariablesTyped() {
        return this.getVariablesTyped(true);
    }

    public VariableMapImpl getVariablesTyped(boolean deserializeValues) {
        VariableMapImpl variableMap = new VariableMapImpl();
        this.collectVariables(variableMap, null, false, deserializeValues);
        return variableMap;
    }

    public VariableMapImpl getVariablesLocal() {
        return this.getVariablesLocalTyped();
    }

    public VariableMapImpl getVariablesLocalTyped() {
        return this.getVariablesLocalTyped(true);
    }

    public VariableMapImpl getVariablesLocalTyped(boolean deserializeObjectValues) {
        VariableMapImpl variables = new VariableMapImpl();
        this.collectVariables(variables, null, true, deserializeObjectValues);
        return variables;
    }

    public void collectVariables(VariableMapImpl resultVariables, Collection<String> variableNames, boolean isLocal, boolean deserializeValues) {
        AbstractVariableScope parentScope;
        boolean collectAll = variableNames == null;
        List<CoreVariableInstance> localVariables = this.getVariableInstancesLocal(variableNames);
        for (CoreVariableInstance variableInstance : localVariables) {
            if (resultVariables.containsKey((Object)variableInstance.getName()) || !collectAll && !variableNames.contains(variableInstance.getName())) continue;
            resultVariables.put(variableInstance.getName(), (Object)variableInstance.getTypedValue(deserializeValues));
        }
        if (!(isLocal || (parentScope = this.getParentVariableScope()) == null || !collectAll && resultVariables.keySet().equals(variableNames))) {
            parentScope.collectVariables(resultVariables, variableNames, isLocal, deserializeValues);
        }
    }

    @Override
    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    public Object getVariable(String variableName, boolean deserializeObjectValue) {
        return this.getValueFromVariableInstance(deserializeObjectValue, this.getVariableInstance(variableName));
    }

    @Override
    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    public Object getVariableLocal(String variableName, boolean deserializeObjectValue) {
        return this.getValueFromVariableInstance(deserializeObjectValue, this.getVariableInstanceLocal(variableName));
    }

    protected Object getValueFromVariableInstance(boolean deserializeObjectValue, CoreVariableInstance variableInstance) {
        TypedValue typedValue;
        if (variableInstance != null && (typedValue = variableInstance.getTypedValue(deserializeObjectValue)) != null) {
            return typedValue.getValue();
        }
        return null;
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String variableName) {
        return this.getVariableTyped(variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String variableName, boolean deserializeValue) {
        return this.getTypedValueFromVariableInstance(deserializeValue, this.getVariableInstance(variableName));
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String variableName) {
        return this.getVariableLocalTyped(variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String variableName, boolean deserializeValue) {
        return this.getTypedValueFromVariableInstance(deserializeValue, this.getVariableInstanceLocal(variableName));
    }

    private <T extends TypedValue> T getTypedValueFromVariableInstance(boolean deserializeValue, CoreVariableInstance variableInstance) {
        if (variableInstance != null) {
            return (T)variableInstance.getTypedValue(deserializeValue);
        }
        return null;
    }

    public CoreVariableInstance getVariableInstance(String variableName) {
        CoreVariableInstance variableInstance = this.getVariableInstanceLocal(variableName);
        if (variableInstance != null) {
            return variableInstance;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName);
        }
        return null;
    }

    public CoreVariableInstance getVariableInstanceLocal(String name) {
        return this.getVariableStore().getVariable(name);
    }

    public List<CoreVariableInstance> getVariableInstancesLocal() {
        return this.getVariableStore().getVariables();
    }

    public List<CoreVariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return this.getVariableStore().getVariables(variableNames);
    }

    @Override
    public boolean hasVariables() {
        if (!this.getVariableStore().isEmpty()) {
            return true;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariables();
    }

    @Override
    public boolean hasVariablesLocal() {
        return !this.getVariableStore().isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        AbstractVariableScope parentScope = this.getParentVariableScope();
        return parentScope != null && parentScope.hasVariable(variableName);
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return this.getVariableStore().containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        AbstractVariableScope parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariables()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return this.getVariableStore().getKeys();
    }

    public void setVariables(Map<String, ?> variables, boolean skipJavaSerializationFormatCheck) {
        VariableUtil.setVariables(variables, (name, value) -> this.setVariable(name, value, skipJavaSerializationFormatCheck));
    }

    public void setVariables(Map<String, ?> variables) {
        this.setVariables(variables, false);
    }

    public void setVariablesLocal(Map<String, ?> variables, boolean skipJavaSerializationFormatCheck) {
        VariableUtil.setVariables(variables, (name, value) -> this.setVariableLocal(name, value, skipJavaSerializationFormatCheck));
    }

    public void setVariablesLocal(Map<String, ?> variables) {
        this.setVariablesLocal(variables, false);
    }

    @Override
    public void removeVariables() {
        for (CoreVariableInstance variableInstance : this.getVariableStore().getVariables()) {
            this.invokeVariableLifecycleListenersDelete(variableInstance, this.getSourceActivityVariableScope());
        }
        this.getVariableStore().removeVariables();
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    public void setVariable(String variableName, Object value, boolean skipJavaSerializationFormatCheck) {
        TypedValue typedValue = Variables.untypedValue((Object)value);
        this.setVariable(variableName, typedValue, this.getSourceActivityVariableScope(), skipJavaSerializationFormatCheck);
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, false);
    }

    protected void setVariable(String variableName, TypedValue value, AbstractVariableScope sourceActivityVariableScope, boolean skipJavaSerializationFormatCheck) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value, sourceActivityVariableScope, skipJavaSerializationFormatCheck);
            return;
        }
        AbstractVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityVariableScope == null) {
                parentVariableScope.setVariable(variableName, (Object)value, skipJavaSerializationFormatCheck);
            } else {
                parentVariableScope.setVariable(variableName, value, sourceActivityVariableScope, skipJavaSerializationFormatCheck);
            }
            return;
        }
        this.setVariableLocal(variableName, value, sourceActivityVariableScope, skipJavaSerializationFormatCheck);
    }

    protected void setVariable(String variableName, TypedValue value, AbstractVariableScope sourceActivityVariableScope) {
        this.setVariable(variableName, value, sourceActivityVariableScope, false);
    }

    public void setVariableLocal(String variableName, TypedValue value, AbstractVariableScope sourceActivityExecution, boolean skipJavaSerializationFormatCheck) {
        VariableStore<CoreVariableInstance> variableStore;
        if (!skipJavaSerializationFormatCheck) {
            VariableUtil.checkJavaSerialization(variableName, value);
        }
        if ((variableStore = this.getVariableStore()).containsKey(variableName)) {
            CoreVariableInstance existingInstance = variableStore.getVariable(variableName);
            TypedValue previousValue = existingInstance.getTypedValue(false);
            if (value.isTransient() != previousValue.isTransient()) {
                throw ProcessEngineLogger.CORE_LOGGER.transientVariableException(variableName);
            }
            existingInstance.setValue(value);
            this.invokeVariableLifecycleListenersUpdate(existingInstance, sourceActivityExecution);
        } else if (variableStore.isRemoved(variableName)) {
            CoreVariableInstance existingInstance = variableStore.getRemovedVariable(variableName);
            TypedValue previousValue = existingInstance.getTypedValue(false);
            if (value.isTransient() != previousValue.isTransient()) {
                throw ProcessEngineLogger.CORE_LOGGER.transientVariableException(variableName);
            }
            existingInstance.setValue(value);
            this.getVariableStore().addVariable(existingInstance);
            this.invokeVariableLifecycleListenersUpdate(existingInstance, sourceActivityExecution);
            if (!value.isTransient()) {
                DbEntityManager dbEntityManager = Context.getCommandContext().getDbEntityManager();
                dbEntityManager.undoDelete((VariableInstanceEntity)existingInstance);
            }
        } else {
            CoreVariableInstance variableValue = this.getVariableInstanceFactory().build(variableName, value, value.isTransient());
            this.getVariableStore().addVariable(variableValue);
            this.invokeVariableLifecycleListenersCreate(variableValue, sourceActivityExecution);
        }
    }

    protected void invokeVariableLifecycleListenersCreate(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope) {
        this.invokeVariableLifecycleListenersCreate(variableInstance, sourceScope, this.getVariableInstanceLifecycleListeners());
    }

    protected void invokeVariableLifecycleListenersCreate(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope, List<VariableInstanceLifecycleListener<CoreVariableInstance>> lifecycleListeners) {
        for (VariableInstanceLifecycleListener<CoreVariableInstance> lifecycleListener : lifecycleListeners) {
            lifecycleListener.onCreate(variableInstance, sourceScope);
        }
    }

    protected void invokeVariableLifecycleListenersDelete(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope) {
        this.invokeVariableLifecycleListenersDelete(variableInstance, sourceScope, this.getVariableInstanceLifecycleListeners());
    }

    protected void invokeVariableLifecycleListenersDelete(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope, List<VariableInstanceLifecycleListener<CoreVariableInstance>> lifecycleListeners) {
        for (VariableInstanceLifecycleListener<CoreVariableInstance> lifecycleListener : lifecycleListeners) {
            lifecycleListener.onDelete(variableInstance, sourceScope);
        }
    }

    protected void invokeVariableLifecycleListenersUpdate(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope) {
        this.invokeVariableLifecycleListenersUpdate(variableInstance, sourceScope, this.getVariableInstanceLifecycleListeners());
    }

    protected void invokeVariableLifecycleListenersUpdate(CoreVariableInstance variableInstance, AbstractVariableScope sourceScope, List<VariableInstanceLifecycleListener<CoreVariableInstance>> lifecycleListeners) {
        for (VariableInstanceLifecycleListener<CoreVariableInstance> lifecycleListener : lifecycleListeners) {
            lifecycleListener.onUpdate(variableInstance, sourceScope);
        }
    }

    public void setVariableLocal(String variableName, Object value, boolean skipJavaSerializationFormatCheck) {
        TypedValue typedValue = Variables.untypedValue((Object)value);
        this.setVariableLocal(variableName, typedValue, this.getSourceActivityVariableScope(), skipJavaSerializationFormatCheck);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        this.setVariableLocal(variableName, value, false);
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityVariableScope());
    }

    protected void removeVariable(String variableName, AbstractVariableScope sourceActivityExecution) {
        if (this.getVariableStore().containsKey(variableName)) {
            this.removeVariableLocal(variableName, sourceActivityExecution);
            return;
        }
        AbstractVariableScope parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityVariableScope());
    }

    protected AbstractVariableScope getSourceActivityVariableScope() {
        return this;
    }

    protected void removeVariableLocal(String variableName, AbstractVariableScope sourceActivityExecution) {
        if (this.getVariableStore().containsKey(variableName)) {
            CoreVariableInstance variableInstance = this.getVariableStore().getVariable(variableName);
            this.invokeVariableLifecycleListenersDelete(variableInstance, sourceActivityExecution);
            this.getVariableStore().removeVariable(variableName);
        }
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    @Override
    public void dispatchEvent(VariableEvent variableEvent) {
    }
}

