/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.db.sql;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.AbstractPersistenceSession;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.HasDbReferences;
import org.operaton.bpm.engine.impl.db.HasDbRevision;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.operaton.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.operaton.bpm.engine.impl.util.DatabaseUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.impl.util.ExceptionUtil;
import org.operaton.bpm.engine.impl.util.IoUtil;
import org.operaton.bpm.engine.impl.util.ReflectUtil;

public abstract class DbSqlSession
extends AbstractPersistenceSession {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    public static final String[] PG_JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE", "PARTITIONED TABLE"};
    private static final String COMPONENT_CASE_ENGINE = "case.engine";
    private static final String COMPONENT_DECISION_ENGINE = "decision.engine";
    private static final String COMPONENT_ENGINE = "engine";
    private static final String COMPONENT_HISTORY = "history";
    private static final String COMPONENT_IDENTITY = "identity";
    private static final String DB_OPERATION_CREATE = "create";
    private static final String DB_OPERATION_DROP = "drop";
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;

    protected DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        SqlSessionFactory sqlSessionFactory = dbSqlSessionFactory.getSqlSessionFactory();
        this.sqlSession = ExceptionUtil.doWithExceptionWrapper(() -> ((SqlSessionFactory)sqlSessionFactory).openSession());
    }

    protected DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        SqlSessionFactory sqlSessionFactory = dbSqlSessionFactory.getSqlSessionFactory();
        this.sqlSession = ExceptionUtil.doWithExceptionWrapper(() -> sqlSessionFactory.openSession(connection));
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    @Override
    public List<?> selectList(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        List<Object> resultList = this.executeSelectList(statement, parameter);
        for (Object object : resultList) {
            this.fireEntityLoaded(object);
        }
        return resultList;
    }

    public List<Object> executeSelectList(String statement, Object parameter) {
        return ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.selectList(statement, parameter));
    }

    @Override
    public <T extends DbEntity> T selectById(Class<T> type, String id) {
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(type);
        String mappedSelectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement);
        EnsureUtil.ensureNotNull("no select statement for " + String.valueOf(type) + " in the ibatis mapping files", "selectStatement", (Object)selectStatement);
        Object result = ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.selectOne(mappedSelectStatement, (Object)id));
        this.fireEntityLoaded(result);
        return (T)((DbEntity)result);
    }

    @Override
    public Object selectOne(String statement, Object parameter) {
        String mappedStatement = this.dbSqlSessionFactory.mapStatement(statement);
        Object result = ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.selectOne(mappedStatement, parameter));
        this.fireEntityLoaded(result);
        return result;
    }

    @Override
    public void lock(String statement, Object parameter) {
        if (!DatabaseUtil.checkDatabaseType("h2")) {
            String mappedStatement = this.dbSqlSessionFactory.mapStatement(statement);
            this.executeSelectForUpdate(mappedStatement, parameter);
        } else {
            LOG.debugDisabledPessimisticLocks();
        }
    }

    protected abstract void executeSelectForUpdate(String var1, Object var2);

    protected void entityUpdatePerformed(DbEntityOperation operation, int rowsAffected, PersistenceException failure) {
        if (failure != null) {
            this.configureFailedDbEntityOperation(operation, failure);
        } else {
            DbEntity dbEntity = operation.getEntity();
            if (dbEntity instanceof HasDbRevision) {
                HasDbRevision versionedObject = (HasDbRevision)((Object)dbEntity);
                if (rowsAffected != 1) {
                    operation.setState(DbOperation.State.FAILED_CONCURRENT_MODIFICATION);
                } else {
                    versionedObject.setRevision(versionedObject.getRevisionNext());
                    operation.setState(DbOperation.State.APPLIED);
                }
            } else {
                operation.setState(DbOperation.State.APPLIED);
            }
        }
    }

    protected void bulkUpdatePerformed(DbBulkOperation operation, int rowsAffected, PersistenceException failure) {
        this.bulkOperationPerformed(operation, rowsAffected, failure);
    }

    protected void bulkDeletePerformed(DbBulkOperation operation, int rowsAffected, PersistenceException failure) {
        this.bulkOperationPerformed(operation, rowsAffected, failure);
    }

    protected void bulkOperationPerformed(DbBulkOperation operation, int rowsAffected, PersistenceException failure) {
        if (failure != null) {
            operation.setFailure((Exception)((Object)failure));
            DbOperation.State failedState = DbOperation.State.FAILED_ERROR;
            operation.setState(failedState);
        } else {
            operation.setRowsAffected(rowsAffected);
            operation.setState(DbOperation.State.APPLIED);
        }
    }

    protected void entityDeletePerformed(DbEntityOperation operation, int rowsAffected, PersistenceException failure) {
        if (failure != null) {
            this.configureFailedDbEntityOperation(operation, failure);
        } else {
            operation.setRowsAffected(rowsAffected);
            DbEntity dbEntity = operation.getEntity();
            if (dbEntity instanceof HasDbRevision && rowsAffected == 0) {
                operation.setState(DbOperation.State.FAILED_CONCURRENT_MODIFICATION);
            } else {
                operation.setState(DbOperation.State.APPLIED);
            }
        }
    }

    protected void configureFailedDbEntityOperation(DbEntityOperation operation, PersistenceException failure) {
        DbOperation.State failedState;
        operation.setRowsAffected(0);
        operation.setFailure((Exception)((Object)failure));
        DbOperationType operationType = operation.getOperationType();
        DbOperation dependencyOperation = operation.getDependentOperation();
        if (this.isConcurrentModificationException(operation, failure)) {
            failedState = DatabaseUtil.checkDatabaseRollsBackTransactionOnError() ? DbOperation.State.FAILED_CONCURRENT_MODIFICATION_EXCEPTION : DbOperation.State.FAILED_CONCURRENT_MODIFICATION;
        } else if (DbOperationType.DELETE.equals((Object)operationType) && dependencyOperation != null && dependencyOperation.getState() != null && dependencyOperation.getState() != DbOperation.State.APPLIED) {
            LOG.ignoreFailureDuePreconditionNotMet(operation, "Parent database operation failed", dependencyOperation);
            failedState = DbOperation.State.NOT_APPLIED;
        } else {
            failedState = DbOperation.State.FAILED_ERROR;
        }
        operation.setState(failedState);
    }

    protected boolean isConcurrentModificationException(DbOperation failedOperation, PersistenceException cause) {
        DbEntityOperation dbEntityOperation;
        Object object;
        boolean isConstraintViolation = ExceptionUtil.checkForeignKeyConstraintViolation(cause);
        boolean isVariableIntegrityViolation = ExceptionUtil.checkVariableIntegrityViolation(cause);
        if (isVariableIntegrityViolation) {
            return true;
        }
        if (isConstraintViolation && failedOperation instanceof DbEntityOperation && (object = (dbEntityOperation = (DbEntityOperation)failedOperation).getEntity()) instanceof HasDbReferences) {
            HasDbReferences hasDbReferences = (HasDbReferences)object;
            if (failedOperation.getOperationType().equals((Object)DbOperationType.INSERT) || failedOperation.getOperationType().equals((Object)DbOperationType.UPDATE)) {
                if (DatabaseUtil.checkDatabaseRollsBackTransactionOnError()) {
                    return Context.getCommandContext().getProcessEngineConfiguration().isEnableOptimisticLockingOnForeignKeyViolation();
                }
                for (Map.Entry entry : hasDbReferences.getReferencedEntitiesIdAndClass().entrySet()) {
                    Object referencedEntity = this.selectById((Class)entry.getValue(), (String)entry.getKey());
                    if (referencedEntity != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void insertEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(dbEntity);
        insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement);
        EnsureUtil.ensureNotNull("no insert statement for " + String.valueOf(dbEntity.getClass()) + " in the ibatis mapping files", "insertStatement", (Object)insertStatement);
        this.executeInsertEntity(insertStatement, dbEntity);
    }

    protected void executeInsertEntity(String insertStatement, Object parameter) {
        LOG.executeDatabaseOperation("INSERT", parameter);
        this.sqlSession.insert(insertStatement, parameter);
    }

    protected void entityInsertPerformed(DbEntityOperation operation, int rowsAffected, PersistenceException failure) {
        DbEntity entity = operation.getEntity();
        if (failure != null) {
            this.configureFailedDbEntityOperation(operation, failure);
        } else {
            if (entity instanceof HasDbRevision) {
                HasDbRevision versionedObject = (HasDbRevision)((Object)entity);
                versionedObject.setRevision(1);
            }
            operation.setState(DbOperation.State.APPLIED);
        }
    }

    protected int executeDelete(String deleteStatement, Object parameter) {
        String mappedDeleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement);
        return this.sqlSession.delete(mappedDeleteStatement, parameter);
    }

    public int executeUpdate(String updateStatement, Object parameter) {
        String mappedUpdateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement);
        return this.sqlSession.update(mappedUpdateStatement, parameter);
    }

    public int update(String updateStatement, Object parameter) {
        return ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.update(updateStatement, parameter));
    }

    @Override
    public int executeNonEmptyUpdateStmt(String updateStmt, Object parameter) {
        String mappedUpdateStmt = this.dbSqlSessionFactory.mapStatement(updateStmt);
        boolean isMappedStmtEmpty = ExceptionUtil.doWithExceptionWrapper(() -> {
            Configuration configuration = this.sqlSession.getConfiguration();
            MappedStatement mappedStatement = configuration.getMappedStatement(mappedUpdateStmt);
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            String sql = boundSql.getSql();
            return sql.isEmpty();
        });
        if (isMappedStmtEmpty) {
            return 0;
        }
        return this.update(mappedUpdateStmt, parameter);
    }

    @Override
    public void flush() {
    }

    @Override
    public void flushOperations() {
        ExceptionUtil.doWithExceptionWrapper(this::flushBatchOperations);
    }

    public List<BatchResult> flushBatchOperations() {
        return this.sqlSession.flushStatements();
    }

    @Override
    public void close() {
        ExceptionUtil.doWithExceptionWrapper(() -> {
            this.sqlSession.close();
            return null;
        });
    }

    @Override
    public void commit() {
        ExceptionUtil.doWithExceptionWrapper(() -> {
            this.sqlSession.commit();
            return null;
        });
    }

    @Override
    public void rollback() {
        ExceptionUtil.doWithExceptionWrapper(() -> {
            this.sqlSession.rollback();
            return null;
        });
    }

    @Override
    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw LOG.wrongDbVersionException("fox", dbVersion);
            }
            ArrayList<String> missingComponents = new ArrayList<String>();
            if (!this.isEngineTablePresent()) {
                missingComponents.add(COMPONENT_ENGINE);
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                missingComponents.add(COMPONENT_HISTORY);
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                missingComponents.add(COMPONENT_IDENTITY);
            }
            if (this.dbSqlSessionFactory.isCmmnEnabled() && !this.isCmmnTablePresent()) {
                missingComponents.add(COMPONENT_CASE_ENGINE);
            }
            if (this.dbSqlSessionFactory.isDmnEnabled() && !this.isDmnTablePresent()) {
                missingComponents.add(COMPONENT_DECISION_ENGINE);
            }
            if (!missingComponents.isEmpty()) {
                throw LOG.missingTableException(missingComponents);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw LOG.missingActivitiTablesException();
            }
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            throw LOG.unableToFetchDbSchemaVersion(e);
        }
    }

    @Override
    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return ExceptionUtil.doWithExceptionWrapper(() -> (String)this.sqlSession.selectOne(selectSchemaVersionStatement));
    }

    @Override
    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, COMPONENT_IDENTITY);
    }

    @Override
    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, COMPONENT_HISTORY);
    }

    @Override
    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, COMPONENT_ENGINE);
    }

    @Override
    protected void dbSchemaCreateCmmn() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, COMPONENT_CASE_ENGINE);
    }

    @Override
    protected void dbSchemaCreateCmmnHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, "case.history");
    }

    @Override
    protected void dbSchemaCreateDmn() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, COMPONENT_DECISION_ENGINE);
    }

    @Override
    protected void dbSchemaCreateDmnHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_CREATE, "decision.history");
    }

    @Override
    protected void dbSchemaDropIdentity() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, COMPONENT_IDENTITY);
    }

    @Override
    protected void dbSchemaDropHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, COMPONENT_HISTORY);
    }

    @Override
    protected void dbSchemaDropEngine() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, COMPONENT_ENGINE);
    }

    @Override
    protected void dbSchemaDropCmmn() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, COMPONENT_CASE_ENGINE);
    }

    @Override
    protected void dbSchemaDropCmmnHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, "case.history");
    }

    @Override
    protected void dbSchemaDropDmn() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, COMPONENT_DECISION_ENGINE);
    }

    @Override
    protected void dbSchemaDropDmnHistory() {
        this.executeMandatorySchemaResource(DB_OPERATION_DROP, "decision.history");
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    @Override
    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    @Override
    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    @Override
    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    @Override
    public boolean isCmmnTablePresent() {
        return this.isTablePresent("ACT_RE_CASE_DEF");
    }

    @Override
    public boolean isCmmnHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_CASEINST");
    }

    @Override
    public boolean isDmnTablePresent() {
        return this.isTablePresent("ACT_RE_DECISION_DEF");
    }

    @Override
    public boolean isDmnHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_DECINST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        block8: {
            tableName = this.prependDatabaseTablePrefix(tableName);
            Connection connection = null;
            connection = ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.getConnection());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet tables = null;
            String schema = this.connectionMetadataDefaultSchema;
            if (this.dbSqlSessionFactory.getDatabaseSchema() != null) {
                schema = this.dbSqlSessionFactory.getDatabaseSchema();
            }
            if (DatabaseUtil.checkDatabaseType("postgres")) {
                tableName = tableName.toLowerCase();
            }
            try {
                tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, this.getTableTypes());
                bl = tables.next();
                if (tables == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tables != null) {
                        tables.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw LOG.checkDatabaseTableException(e);
                }
            }
            tables.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTableNamesPresent() {
        ArrayList<String> tableNames = new ArrayList();
        try (ResultSet tablesRs = null;){
            if ("oracle".equals(this.getDbSqlSessionFactory().getDatabaseType())) {
                tableNames = this.getTablesPresentInOracleDatabase();
            } else {
                Connection connection = this.getSqlSession().getConnection();
                String databaseTablePrefix = this.getDbSqlSessionFactory().getDatabaseTablePrefix();
                String schema = this.getDbSqlSessionFactory().getDatabaseSchema();
                String tableNameFilter = this.prependDatabaseTablePrefix("ACT_%");
                if (DatabaseUtil.checkDatabaseType("postgres")) {
                    schema = schema == null ? schema : schema.toLowerCase();
                    tableNameFilter = tableNameFilter.toLowerCase();
                }
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                tablesRs = databaseMetaData.getTables(null, schema, tableNameFilter, this.getTableTypes());
                while (tablesRs.next()) {
                    Object tableName = tablesRs.getString("TABLE_NAME");
                    if (!databaseTablePrefix.isEmpty()) {
                        tableName = databaseTablePrefix + (String)tableName;
                    }
                    tableName = ((String)tableName).toUpperCase();
                    tableNames.add((String)tableName);
                }
                LOG.fetchDatabaseTables("jdbc metadata", tableNames);
            }
        }
        catch (Exception e) {
            throw LOG.getDatabaseTableNameException(e);
        }
        return tableNames;
    }

    protected List<String> getTablesPresentInOracleDatabase() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String selectTableNamesFromOracle = "SELECT table_name FROM all_tables WHERE table_name LIKE ? ESCAPE '-'";
        String databaseTablePrefix = this.getDbSqlSessionFactory().getDatabaseTablePrefix();
        try (Connection connection = Context.getProcessEngineConfiguration().getDataSource().getConnection();
             PreparedStatement prepStat = connection.prepareStatement(selectTableNamesFromOracle);){
            prepStat.setString(1, databaseTablePrefix + "ACT-_%");
            try (ResultSet tablesRs = prepStat.executeQuery();){
                while (tablesRs.next()) {
                    String tableName = tablesRs.getString("TABLE_NAME");
                    tableName = tableName.toUpperCase();
                    tableNames.add(tableName);
                }
                LOG.fetchDatabaseTables("oracle all_tables", tableNames);
            }
        }
        return tableNames;
    }

    public String prependDatabaseTablePrefix(String tableName) {
        String prefixWithoutSchema = this.dbSqlSessionFactory.getDatabaseTablePrefix();
        String schema = this.dbSqlSessionFactory.getDatabaseSchema();
        if (prefixWithoutSchema == null) {
            return tableName;
        }
        if (schema == null) {
            return prefixWithoutSchema + tableName;
        }
        if (prefixWithoutSchema.startsWith(schema + ".")) {
            prefixWithoutSchema = prefixWithoutSchema.substring(schema.length() + 1);
        }
        return prefixWithoutSchema + tableName;
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/operaton/bpm/engine/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        try (InputStream inputStream = ReflectUtil.getResourceAsStream(resourceName);){
            if (inputStream == null) {
                if (!isOptional) throw LOG.missingSchemaResourceException(resourceName, operation);
                LOG.missingSchemaResource(resourceName, operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void executeSchemaResource(String schemaFileResourceName) {
        try (FileInputStream inputStream = new FileInputStream(schemaFileResourceName);){
            this.executeSchemaResource("schema operation", "process engine", schemaFileResourceName, inputStream);
        }
        catch (FileNotFoundException e) {
            throw LOG.missingSchemaResourceFileException(schemaFileResourceName, e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = ExceptionUtil.doWithExceptionWrapper(() -> this.sqlSession.getConnection());
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            ArrayList<String> logLines = new ArrayList<String>();
            while (line != null) {
                if (line.startsWith("# ")) {
                    logLines.add(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    logLines.add(line.substring(3));
                } else if (!line.isEmpty()) {
                    if (line.endsWith(";")) {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                        try {
                            Statement jdbcStatement = connection.createStatement();
                            logLines.add(sqlStatement);
                            jdbcStatement.execute(sqlStatement);
                            jdbcStatement.close();
                        }
                        catch (Exception e) {
                            if (exception == null) {
                                exception = e;
                                exceptionSqlStatement = sqlStatement;
                            }
                            LOG.failedDatabaseOperation(operation, sqlStatement, e);
                        }
                        finally {
                            sqlStatement = null;
                        }
                    } else {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            LOG.performingDatabaseOperation(operation, component, resourceName);
            LOG.executingDDL(logLines);
            if (exception != null) {
                throw exception;
            }
            LOG.successfulDatabaseOperation(operation, component);
        }
        catch (Exception e) {
            throw LOG.performDatabaseOperationException(operation, exceptionSqlStatement, e);
        }
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            String exceptionMessage = cause.getMessage();
            if (cause.getMessage() != null) {
                if (exceptionMessage.contains("Table") && exceptionMessage.contains("not found")) {
                    return true;
                }
                if ((exceptionMessage.contains("Table") || exceptionMessage.contains("table")) && exceptionMessage.contains("doesn't exist")) {
                    return true;
                }
                return (exceptionMessage.contains("relation") || exceptionMessage.contains("table")) && exceptionMessage.contains("does not exist");
            }
        }
        return false;
    }

    protected String[] getTableTypes() {
        if (DatabaseUtil.checkDatabaseType("postgres")) {
            return PG_JDBC_METADATA_TABLE_TYPES;
        }
        return JDBC_METADATA_TABLE_TYPES;
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }
}

