/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.db.sql;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.FlushResult;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.db.sql.DbSqlSession;
import org.operaton.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SimpleDbSqlSession
extends DbSqlSession {
    public SimpleDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        super(dbSqlSessionFactory);
    }

    public SimpleDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, connection, catalog, schema);
    }

    @Override
    protected void executeSelectForUpdate(String statement, Object parameter) {
        this.update(statement, parameter);
    }

    @Override
    public FlushResult executeDbOperations(List<DbOperation> operations) {
        for (int i = 0; i < operations.size(); ++i) {
            DbOperation operation = operations.get(i);
            this.executeDbOperation(operation);
            if (!operation.isFailed()) continue;
            List<DbOperation> remainingOperations = operations.subList(i + 1, operations.size());
            return FlushResult.withFailuresAndRemaining(Collections.singletonList(operation), remainingOperations);
        }
        return FlushResult.allApplied();
    }

    @Override
    protected void insertEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(dbEntity);
        insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement);
        EnsureUtil.ensureNotNull("no insert statement for " + String.valueOf(dbEntity.getClass()) + " in the ibatis mapping files", "insertStatement", (Object)insertStatement);
        try {
            this.executeInsertEntity(insertStatement, dbEntity);
            this.entityInsertPerformed(operation, 1, null);
        }
        catch (PersistenceException e) {
            this.entityInsertPerformed(operation, 0, e);
        }
    }

    @Override
    protected void deleteEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(dbEntity.getClass());
        EnsureUtil.ensureNotNull("no delete statement for " + String.valueOf(dbEntity.getClass()) + " in the ibatis mapping files", "deleteStatement", (Object)deleteStatement);
        LOG.executeDatabaseOperation("DELETE", dbEntity);
        try {
            int nrOfRowsDeleted = this.executeDelete(deleteStatement, dbEntity);
            this.entityDeletePerformed(operation, nrOfRowsDeleted, null);
        }
        catch (PersistenceException e) {
            this.entityDeletePerformed(operation, 0, e);
        }
    }

    @Override
    protected void deleteBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("DELETE", statement, parameter);
        try {
            int rowsAffected = this.executeDelete(statement, parameter);
            this.bulkDeletePerformed(operation, rowsAffected, null);
        }
        catch (PersistenceException e) {
            this.bulkDeletePerformed(operation, 0, e);
        }
    }

    @Override
    protected void updateEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(dbEntity);
        EnsureUtil.ensureNotNull("no update statement for " + String.valueOf(dbEntity.getClass()) + " in the ibatis mapping files", "updateStatement", (Object)updateStatement);
        LOG.executeDatabaseOperation("UPDATE", dbEntity);
        try {
            int rowsAffected = this.executeUpdate(updateStatement, dbEntity);
            this.entityUpdatePerformed(operation, rowsAffected, null);
        }
        catch (PersistenceException e) {
            this.entityUpdatePerformed(operation, 0, e);
        }
    }

    @Override
    protected void updateBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("UPDATE", statement, parameter);
        try {
            int rowsAffected = this.executeUpdate(statement, parameter);
            this.bulkUpdatePerformed(operation, rowsAffected, null);
        }
        catch (PersistenceException e) {
            this.bulkUpdatePerformed(operation, 0, e);
        }
    }
}

