/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.digest;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.operaton.bpm.engine.ProcessEngineException;

public abstract class Base64EncodedHashDigest {
    public String encrypt(String password) {
        byte[] hash = this.createByteHash(password);
        return this.encodeHash(hash);
    }

    public boolean check(String password, String encrypted) {
        return this.encrypt(password).equals(encrypted);
    }

    protected byte[] createByteHash(String password) {
        MessageDigest digest = this.createDigestInstance();
        digest.update(password.getBytes(StandardCharsets.UTF_8));
        return digest.digest();
    }

    protected MessageDigest createDigestInstance() {
        try {
            return MessageDigest.getInstance(this.hashAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessEngineException("Cannot lookup " + this.hashAlgorithmName() + " algorithm");
        }
    }

    protected String encodeHash(byte[] hash) {
        return Base64.getEncoder().encodeToString(hash);
    }

    protected abstract String hashAlgorithmName();
}

