/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn.deployer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.operaton.bpm.engine.impl.AbstractDefinitionDeployer;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.core.model.Properties;
import org.operaton.bpm.engine.impl.dmn.DecisionLogger;
import org.operaton.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import org.operaton.bpm.engine.impl.dmn.transformer.DecisionDefinitionHandler;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.model.dmn.instance.Decision;

public class DecisionRequirementsDefinitionDeployer
extends AbstractDefinitionDeployer<DecisionRequirementsDefinitionEntity> {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;
    protected DmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<DecisionRequirementsDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        byte[] bytes = resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (!deployment.isNew()) {
            this.skipEnforceTtl(true);
        }
        try {
            DecisionRequirementsDefinitionEntity drd = (DecisionRequirementsDefinitionEntity)this.transformer.createTransform().modelInstance((InputStream)inputStream).transformDecisionRequirementsGraph();
            List<DecisionRequirementsDefinitionEntity> list = Collections.singletonList(drd);
            return list;
        }
        catch (Exception e) {
            throw LOG.exceptionParseDmnResource(resource.getName(), e);
        }
        finally {
            this.skipEnforceTtl(false);
        }
    }

    public void skipEnforceTtl(boolean skipEnforceTtl) {
        DmnElementTransformHandler handler = this.transformer.getElementTransformHandlerRegistry().getHandler(Decision.class);
        ((DecisionDefinitionHandler)handler).setSkipEnforceTtl(skipEnforceTtl);
    }

    @Override
    protected DecisionRequirementsDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getDecisionRequirementsDefinitionManager().findDecisionRequirementsDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected DecisionRequirementsDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getDecisionRequirementsDefinitionManager().findLatestDecisionRequirementsDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(DecisionRequirementsDefinitionEntity definition) {
        if (DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) {
            this.getDecisionRequirementsDefinitionManager().insertDecisionRequirementsDefinition(definition);
        }
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, DecisionRequirementsDefinitionEntity definition) {
        if (DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) {
            deploymentCache.addDecisionRequirementsDefinition(definition);
        }
    }

    @Override
    protected void ensureNoDuplicateDefinitionKeys(List<DecisionRequirementsDefinitionEntity> definitions) {
        ArrayList<DecisionRequirementsDefinitionEntity> persistableDefinitions = new ArrayList<DecisionRequirementsDefinitionEntity>();
        for (DecisionRequirementsDefinitionEntity definition : definitions) {
            if (!DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(definition)) continue;
            persistableDefinitions.add(definition);
        }
        super.ensureNoDuplicateDefinitionKeys(persistableDefinitions);
    }

    public static boolean isDecisionRequirementsDefinitionPersistable(DecisionRequirementsDefinitionEntity definition) {
        return definition.getDecisions().size() > 1;
    }

    @Override
    protected void updateDefinitionByPersistedDefinition(DeploymentEntity deployment, DecisionRequirementsDefinitionEntity definition, DecisionRequirementsDefinitionEntity persistedDefinition) {
        if (persistedDefinition != null) {
            super.updateDefinitionByPersistedDefinition(deployment, definition, persistedDefinition);
        }
    }

    protected DecisionRequirementsDefinitionManager getDecisionRequirementsDefinitionManager() {
        return this.getCommandContext().getDecisionRequirementsDefinitionManager();
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }
}

