/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.externaltask;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.operaton.bpm.engine.externaltask.FetchAndLockBuilder;
import org.operaton.bpm.engine.impl.Direction;
import org.operaton.bpm.engine.impl.ExternalTaskQueryProperty;
import org.operaton.bpm.engine.impl.QueryOrderingProperty;
import org.operaton.bpm.engine.impl.externaltask.ExternalTaskQueryTopicBuilderImpl;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.commons.utils.CollectionUtil;

public class FetchAndLockBuilderImpl
implements FetchAndLockBuilder {
    protected final CommandExecutor commandExecutor;
    protected String workerId;
    protected int maxTasks;
    protected boolean usePriority;
    protected List<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();

    public FetchAndLockBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public FetchAndLockBuilderImpl workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl maxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl usePriority(boolean usePriority) {
        this.usePriority = usePriority;
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl orderByCreateTime() {
        this.orderingProperties.add(new QueryOrderingProperty(ExternalTaskQueryProperty.CREATE_TIME, null));
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl asc() throws NotValidException {
        this.configureLastOrderingPropertyDirection(Direction.ASCENDING);
        return this;
    }

    @Override
    public FetchAndLockBuilderImpl desc() throws NotValidException {
        this.configureLastOrderingPropertyDirection(Direction.DESCENDING);
        return this;
    }

    @Override
    public ExternalTaskQueryTopicBuilder subscribe() {
        this.checkQueryOk();
        return new ExternalTaskQueryTopicBuilderImpl(this.commandExecutor, this.workerId, this.maxTasks, this.usePriority, this.orderingProperties);
    }

    protected void configureLastOrderingPropertyDirection(Direction direction) {
        QueryOrderingProperty lastProperty = this.orderingProperties.isEmpty() ? null : (QueryOrderingProperty)CollectionUtil.getLastElement(this.orderingProperties);
        EnsureUtil.ensureNotNull(NotValidException.class, "You should call any of the orderBy methods first before specifying a direction", "currentOrderingProperty", (Object)lastProperty);
        if (lastProperty.getDirection() != null) {
            EnsureUtil.ensureNull(NotValidException.class, "Invalid query: can specify only one direction desc() or asc() for an ordering constraint", "direction", direction);
        }
        lastProperty.setDirection(direction);
    }

    protected void checkQueryOk() {
        for (QueryOrderingProperty orderingProperty : this.orderingProperties) {
            EnsureUtil.ensureNotNull(NotValidException.class, "Invalid query: call asc() or desc() after using orderByXX()", "direction", (Object)orderingProperty.getDirection());
        }
    }
}

