/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.handler;

import java.util.concurrent.Callable;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.form.handler.FormHandler;
import org.operaton.bpm.engine.impl.form.handler.SubmitFormVariablesInvocation;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.xml.Element;
import org.operaton.bpm.engine.variable.VariableMap;

public abstract class DelegateFormHandler {
    protected String deploymentId;
    protected FormHandler formHandler;

    protected DelegateFormHandler(FormHandler formHandler, String deploymentId) {
        this.formHandler = formHandler;
        this.deploymentId = deploymentId;
    }

    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
    }

    protected <T> T performContextSwitch(Callable<T> callable) {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication(this.deploymentId);
        if (targetProcessApplication != null) {
            return (T)Context.executeWithinProcessApplication(() -> this.doCall(callable), targetProcessApplication);
        }
        return this.doCall(callable);
    }

    protected <T> T doCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }

    public void submitFormVariables(VariableMap properties, VariableScope variableScope) {
        this.performContextSwitch(() -> {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new SubmitFormVariablesInvocation(this.formHandler, properties, variableScope));
            return null;
        });
    }

    public abstract FormHandler getFormHandler();
}

