/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.form.FormField;
import org.operaton.bpm.engine.form.FormFieldValidationConstraint;
import org.operaton.bpm.engine.form.FormType;
import org.operaton.bpm.engine.impl.el.StartProcessVariableScope;
import org.operaton.bpm.engine.impl.form.FormFieldImpl;
import org.operaton.bpm.engine.impl.form.handler.FormFieldValidationConstraintHandler;
import org.operaton.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.variable.VariableMap;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class FormFieldHandler {
    protected String id;
    protected Expression label;
    protected AbstractFormFieldType type;
    protected Expression defaultValueExpression;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected List<FormFieldValidationConstraintHandler> validationHandlers = new ArrayList<FormFieldValidationConstraintHandler>();
    protected boolean businessKey;

    public FormField createFormField(ExecutionEntity executionEntity) {
        Object value;
        Object labelValueObject;
        VariableScope variableScope;
        FormFieldImpl formField = new FormFieldImpl();
        formField.setId(this.id);
        VariableScope variableScope2 = variableScope = executionEntity != null ? executionEntity : StartProcessVariableScope.getSharedInstance();
        if (this.label != null && (labelValueObject = this.label.getValue(variableScope)) != null) {
            formField.setLabel(labelValueObject.toString());
        }
        formField.setBusinessKey(this.businessKey);
        formField.setType(this.type);
        Object defaultValue = null;
        if (this.defaultValueExpression != null) {
            defaultValue = this.defaultValueExpression.getValue(variableScope);
            if (defaultValue != null) {
                formField.setDefaultValue(this.type.convertFormValueToModelValue(defaultValue));
            } else {
                formField.setDefaultValue(null);
            }
        }
        if ((value = variableScope.getVariableTyped(this.id)) != null) {
            TypedValue formValue;
            try {
                formValue = this.type.convertToFormValue((TypedValue)value);
            }
            catch (Exception exception) {
                throw new FormFieldValidationException(this.id, "failed to convert '" + this.id + "'", exception);
            }
            formField.setValue(formValue);
        } else {
            TypedValue typedDefaultValue = this.type.convertToModelValue(Variables.untypedValue((Object)defaultValue));
            formField.setValue(this.type.convertToFormValue(typedDefaultValue));
        }
        formField.setProperties(this.properties);
        List<FormFieldValidationConstraint> validationConstraints = formField.getValidationConstraints();
        for (FormFieldValidationConstraintHandler validationHandler : this.validationHandlers) {
            if ("validator".equals(validationHandler.name)) continue;
            validationConstraints.add(validationHandler.createValidationConstraint(executionEntity));
        }
        return formField;
    }

    public void handleSubmit(VariableScope variableScope, VariableMap values, VariableMap allValues) {
        TypedValue submittedValue = values.getValueTyped(this.id);
        values.remove((Object)this.id);
        for (FormFieldValidationConstraintHandler validationHandler : this.validationHandlers) {
            Object value = null;
            if (submittedValue != null) {
                value = submittedValue.getValue();
            }
            validationHandler.validate(value, allValues, this, variableScope);
        }
        TypedValue modelValue = null;
        if (submittedValue != null) {
            modelValue = this.type != null ? this.type.convertToModelValue(submittedValue) : submittedValue;
        } else if (this.defaultValueExpression != null) {
            TypedValue expressionValue = Variables.untypedValue((Object)this.defaultValueExpression.getValue(variableScope));
            if (this.type != null) {
                modelValue = this.type.convertToModelValue(Variables.untypedValue((Object)expressionValue));
            } else if (expressionValue != null) {
                modelValue = Variables.stringValue((String)expressionValue.getValue().toString());
            }
        }
        if (modelValue != null && this.id != null) {
            variableScope.setVariable(this.id, modelValue);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression name) {
        this.label = name;
    }

    public void setType(AbstractFormFieldType formType) {
        this.type = formType;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public FormType getType() {
        return this.type;
    }

    public Expression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public void setDefaultValueExpression(Expression defaultValue) {
        this.defaultValueExpression = defaultValue;
    }

    public List<FormFieldValidationConstraintHandler> getValidationHandlers() {
        return this.validationHandlers;
    }

    public void setValidationHandlers(List<FormFieldValidationConstraintHandler> validationHandlers) {
        this.validationHandlers = validationHandlers;
    }

    public void setBusinessKey(boolean businessKey) {
        this.businessKey = businessKey;
    }

    public boolean isBusinessKey() {
        return this.businessKey;
    }
}

