/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.validator;

import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidator;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidatorInvocation;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.util.ReflectUtil;

public class DelegateFormFieldValidator
implements FormFieldValidator {
    protected String clazz;
    protected Expression delegateExpression;

    public DelegateFormFieldValidator(Expression expression) {
        this.delegateExpression = expression;
    }

    public DelegateFormFieldValidator(String clazz) {
        this.clazz = clazz;
    }

    public DelegateFormFieldValidator() {
    }

    @Override
    public boolean validate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        DelegateExecution execution = validatorContext.getExecution();
        if (this.shouldPerformPaContextSwitch(validatorContext.getExecution())) {
            ProcessApplicationReference processApplicationReference = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
            return Context.executeWithinProcessApplication(() -> this.doValidate(submittedValue, validatorContext), processApplicationReference, new InvocationContext(execution));
        }
        return this.doValidate(submittedValue, validatorContext);
    }

    protected boolean shouldPerformPaContextSwitch(DelegateExecution execution) {
        if (execution == null) {
            return false;
        }
        ProcessApplicationReference targetPa = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        return targetPa != null && !targetPa.equals(Context.getCurrentProcessApplication());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doValidate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        FormFieldValidator validator;
        if (this.clazz != null) {
            validatorObject = ReflectUtil.instantiate(this.clazz);
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator class '" + this.clazz + "' is not an instance of " + FormFieldValidator.class.getName());
            validator = formFieldValidator = (FormFieldValidator)validatorObject;
        } else {
            validatorObject = this.delegateExpression.getValue(validatorContext.getExecution());
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator expression '" + String.valueOf(this.delegateExpression) + "' does not resolve to instance of " + FormFieldValidator.class.getName());
            validator = formFieldValidator = (FormFieldValidator)validatorObject;
        }
        FormFieldValidatorInvocation invocation = new FormFieldValidatorInvocation(validator, submittedValue, validatorContext);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }
}

