/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.history.producer;

import org.operaton.bpm.engine.delegate.DelegateTask;
import org.operaton.bpm.engine.impl.batch.BatchEntity;
import org.operaton.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.operaton.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.operaton.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.operaton.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.operaton.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.history.producer.DefaultHistoryEventProducer;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.runtime.Incident;

public class CacheAwareHistoryEventProducer
extends DefaultHistoryEventProducer {
    @Override
    protected HistoricActivityInstanceEventEntity loadActivityInstanceEventEntity(ExecutionEntity execution) {
        String activityInstanceId = execution.getActivityInstanceId();
        HistoricActivityInstanceEventEntity cachedEntity = this.findInCache(HistoricActivityInstanceEventEntity.class, activityInstanceId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newActivityInstanceEventEntity(execution);
    }

    @Override
    protected HistoricProcessInstanceEventEntity loadProcessInstanceEventEntity(ExecutionEntity execution) {
        String processInstanceId = execution.getProcessInstanceId();
        HistoricProcessInstanceEventEntity cachedEntity = this.findInCache(HistoricProcessInstanceEventEntity.class, processInstanceId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newProcessInstanceEventEntity(execution);
    }

    @Override
    protected HistoricTaskInstanceEventEntity loadTaskInstanceEvent(DelegateTask task) {
        String taskId = task.getId();
        HistoricTaskInstanceEventEntity cachedEntity = this.findInCache(HistoricTaskInstanceEventEntity.class, taskId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newTaskInstanceEventEntity(task);
    }

    @Override
    protected HistoricIncidentEventEntity loadIncidentEvent(Incident incident) {
        String incidentId = incident.getId();
        HistoricIncidentEventEntity cachedEntity = this.findInCache(HistoricIncidentEventEntity.class, incidentId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newIncidentEventEntity(incident);
    }

    @Override
    protected HistoricBatchEntity loadBatchEntity(BatchEntity batch) {
        String batchId = batch.getId();
        HistoricBatchEntity cachedEntity = this.findInCache(HistoricBatchEntity.class, batchId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newBatchEventEntity(batch);
    }

    protected <T extends HistoryEvent> T findInCache(Class<T> type, String id) {
        return (T)((HistoryEvent)Context.getCommandContext().getDbEntityManager().getCachedEntity(type, id));
    }

    @Override
    protected ProcessDefinitionEntity getProcessDefinitionEntity(String processDefinitionId) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return null;
        }
        DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
        if (dbEntityManager == null) {
            return null;
        }
        ProcessDefinitionEntity cachedEntity = dbEntityManager.getCachedEntity(ProcessDefinitionEntity.class, processDefinitionId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return super.getProcessDefinitionEntity(processDefinitionId);
    }
}

