/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.interceptor;

import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.diagnostics.DiagnosticsRegistry;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;
import org.operaton.bpm.engine.impl.util.ClassNameUtil;

public class CommandCounterInterceptor
extends CommandInterceptor {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public CommandCounterInterceptor(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        try {
            T t = this.next.execute(command);
            return t;
        }
        finally {
            DiagnosticsRegistry diagnosticsRegistry = this.processEngineConfiguration.getDiagnosticsRegistry();
            if (diagnosticsRegistry != null) {
                String className = ClassNameUtil.getClassNameWithoutPackage(command);
                if (!command.getClass().isAnonymousClass() && !className.contains("$$Lambda")) {
                    className = this.parseLocalClassName(className);
                    diagnosticsRegistry.markOccurrence(className);
                }
            }
        }
    }

    protected String parseLocalClassName(String className) {
        return className.replace("$", "_");
    }
}

