/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutor;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutorLogger;

public abstract class AcquireJobsRunnable
implements Runnable {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted;
    protected volatile boolean isJobAdded;
    protected final Object monitor = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    protected AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendAcquisition(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            LOG.debugJobAcquisitionThreadSleeping(millis);
            Object object = this.monitor;
            synchronized (object) {
                if (!this.isInterrupted) {
                    this.isWaiting.set(true);
                    this.monitor.wait(millis);
                }
            }
            LOG.jobExecutorThreadWokeUp();
        }
        catch (InterruptedException e) {
            LOG.jobExecutionWaitInterrupted();
        }
        finally {
            this.isWaiting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    protected void clearJobAddedNotification() {
        this.isJobAdded = false;
    }

    public boolean isJobAdded() {
        return this.isJobAdded;
    }
}

