/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor.historycleanup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.operaton.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import org.operaton.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public final class HistoryCleanupHelper {
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS = new SimpleDateFormat("yyyy-MM-ddHH:mm");
    private static final SimpleDateFormat TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE = new SimpleDateFormat("yyyy-MM-ddHH:mmZ");
    private static final SimpleDateFormat DATE_FORMAT_WITHOUT_TIME = new SimpleDateFormat("yyyy-MM-dd");

    private HistoryCleanupHelper() {
    }

    public static int getMaxRetries() {
        boolean isConfiguredByUser;
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        boolean bl = isConfiguredByUser = config.getHistoryCleanupDefaultNumberOfRetries() != Integer.MIN_VALUE;
        if (!isConfiguredByUser) {
            return config.getDefaultNumberOfRetries();
        }
        return config.getHistoryCleanupDefaultNumberOfRetries();
    }

    public static boolean isWithinBatchWindow(Date date, ProcessEngineConfigurationImpl configuration) {
        if (configuration.getBatchWindowManager().isBatchWindowConfigured(configuration)) {
            BatchWindow batchWindow = configuration.getBatchWindowManager().getCurrentOrNextBatchWindow(date, configuration);
            if (batchWindow == null) {
                return false;
            }
            return batchWindow.isWithin(date);
        }
        return false;
    }

    public static synchronized Date parseTimeConfiguration(String time) throws ParseException {
        String today = DATE_FORMAT_WITHOUT_TIME.format(ClockUtil.getCurrentTime());
        try {
            return TIME_FORMAT_WITHOUT_SECONDS_WITH_TIMEZONE.parse(today + time);
        }
        catch (ParseException ex) {
            return TIME_FORMAT_WITHOUT_SECONDS.parse(today + time);
        }
    }

    private static Integer getHistoryCleanupBatchSize(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }

    public static void prepareNextBatch(HistoryCleanupBatch historyCleanupBatch, CommandContext commandContext) {
        List<String> taskMetricIds;
        Integer parsedTaskMetricsTimeToLive;
        List<String> historicBatchIds;
        List<String> historicCaseInstanceIds;
        List<String> historicDecisionInstanceIds;
        HistoryCleanupJobHandlerConfiguration configuration = historyCleanupBatch.getConfiguration();
        Integer batchSize = HistoryCleanupHelper.getHistoryCleanupBatchSize(commandContext);
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        List<String> historicProcessInstanceIds = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceIdsForCleanup(batchSize, configuration.getMinuteFrom(), configuration.getMinuteTo());
        if (!historicProcessInstanceIds.isEmpty()) {
            historyCleanupBatch.setHistoricProcessInstanceIds(historicProcessInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isDmnEnabled() && !(historicDecisionInstanceIds = commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceIdsForCleanup(batchSize - historyCleanupBatch.size(), configuration.getMinuteFrom(), configuration.getMinuteTo())).isEmpty()) {
            historyCleanupBatch.setHistoricDecisionInstanceIds(historicDecisionInstanceIds);
        }
        if (historyCleanupBatch.size() < batchSize && processEngineConfiguration.isCmmnEnabled() && !(historicCaseInstanceIds = commandContext.getHistoricCaseInstanceManager().findHistoricCaseInstanceIdsForCleanup(batchSize - historyCleanupBatch.size(), configuration.getMinuteFrom(), configuration.getMinuteTo())).isEmpty()) {
            historyCleanupBatch.setHistoricCaseInstanceIds(historicCaseInstanceIds);
        }
        Map<String, Integer> batchOperationsForHistoryCleanup = processEngineConfiguration.getParsedBatchOperationsForHistoryCleanup();
        if (historyCleanupBatch.size() < batchSize && batchOperationsForHistoryCleanup != null && !batchOperationsForHistoryCleanup.isEmpty() && !(historicBatchIds = commandContext.getHistoricBatchManager().findHistoricBatchIdsForCleanup(batchSize - historyCleanupBatch.size(), batchOperationsForHistoryCleanup, configuration.getMinuteFrom(), configuration.getMinuteTo())).isEmpty()) {
            historyCleanupBatch.setHistoricBatchIds(historicBatchIds);
        }
        if ((parsedTaskMetricsTimeToLive = processEngineConfiguration.getParsedTaskMetricsTimeToLive()) != null && historyCleanupBatch.size() < batchSize && !(taskMetricIds = commandContext.getMeterLogManager().findTaskMetricsForCleanup(batchSize - historyCleanupBatch.size(), parsedTaskMetricsTimeToLive, configuration.getMinuteFrom(), configuration.getMinuteTo())).isEmpty()) {
            historyCleanupBatch.setTaskMetricIds(taskMetricIds);
        }
    }

    public static int[][] listMinuteChunks(int numberOfChunks) throws IllegalArgumentException {
        if (numberOfChunks <= 0 || numberOfChunks > 60) {
            throw new IllegalArgumentException("Number of chunks must be greater than 0, but is " + numberOfChunks);
        }
        int[][] minuteChunks = new int[numberOfChunks][2];
        int chunkLength = 60 / numberOfChunks;
        for (int i = 0; i < numberOfChunks; ++i) {
            minuteChunks[i][0] = chunkLength * i;
            minuteChunks[i][1] = chunkLength * (i + 1) - 1;
        }
        minuteChunks[numberOfChunks - 1][1] = 59;
        return minuteChunks;
    }

    public static boolean isBatchWindowConfigured(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getBatchWindowManager().isBatchWindowConfigured(commandContext.getProcessEngineConfiguration());
    }
}

