/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.json;

import operatonjar.impl.com.google.gson.JsonObject;
import org.operaton.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.operaton.bpm.engine.impl.cmd.ActivityAfterInstantiationCmd;
import org.operaton.bpm.engine.impl.cmd.ActivityBeforeInstantiationCmd;
import org.operaton.bpm.engine.impl.cmd.ActivityCancellationCmd;
import org.operaton.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.operaton.bpm.engine.impl.cmd.TransitionInstanceCancellationCmd;
import org.operaton.bpm.engine.impl.cmd.TransitionInstantiationCmd;
import org.operaton.bpm.engine.impl.json.JsonObjectConverter;
import org.operaton.bpm.engine.impl.util.JsonUtil;

public class ModificationCmdJsonConverter
extends JsonObjectConverter<AbstractProcessInstanceModificationCommand> {
    public static final ModificationCmdJsonConverter INSTANCE = new ModificationCmdJsonConverter();
    public static final String START_BEFORE = "startBeforeActivity";
    public static final String START_AFTER = "startAfterActivity";
    public static final String START_TRANSITION = "startTransition";
    public static final String CANCEL_ALL = "cancelAllForActivity";
    public static final String CANCEL_CURRENT = "cancelCurrentActiveActivityInstances";
    public static final String CANCEL_ACTIVITY_INSTANCES = "cancelActivityInstances";
    public static final String PROCESS_INSTANCE = "processInstances";
    public static final String CANCEL_TRANSITION_INSTANCES = "cancelTransitionInstances";
    public static final String ANCESTOR_ACTIVITY_INSTANCE_ID = "ancestorActivityInstanceId";

    @Override
    public JsonObject toJsonObject(AbstractProcessInstanceModificationCommand command) {
        JsonObject json = JsonUtil.createObject();
        if (command instanceof ActivityAfterInstantiationCmd) {
            ActivityAfterInstantiationCmd activityAfterInstantiationCmd = (ActivityAfterInstantiationCmd)command;
            JsonUtil.addField(json, START_AFTER, activityAfterInstantiationCmd.getTargetElementId());
            JsonUtil.addField(json, ANCESTOR_ACTIVITY_INSTANCE_ID, activityAfterInstantiationCmd.getAncestorActivityInstanceId());
        } else if (command instanceof ActivityBeforeInstantiationCmd) {
            ActivityBeforeInstantiationCmd activityBeforeInstantiationCmd = (ActivityBeforeInstantiationCmd)command;
            JsonUtil.addField(json, START_BEFORE, activityBeforeInstantiationCmd.getTargetElementId());
            JsonUtil.addField(json, ANCESTOR_ACTIVITY_INSTANCE_ID, activityBeforeInstantiationCmd.getAncestorActivityInstanceId());
        } else if (command instanceof TransitionInstantiationCmd) {
            TransitionInstantiationCmd transitionInstantiationCmd = (TransitionInstantiationCmd)command;
            JsonUtil.addField(json, START_TRANSITION, transitionInstantiationCmd.getTargetElementId());
        } else if (command instanceof ActivityCancellationCmd) {
            ActivityCancellationCmd activityCancellationCmd = (ActivityCancellationCmd)command;
            JsonUtil.addField(json, CANCEL_ALL, activityCancellationCmd.getActivityId());
            JsonUtil.addField(json, CANCEL_CURRENT, activityCancellationCmd.isCancelCurrentActiveActivityInstances());
        } else if (command instanceof ActivityInstanceCancellationCmd) {
            ActivityInstanceCancellationCmd activityInstanceCancellationCmd = (ActivityInstanceCancellationCmd)command;
            JsonUtil.addField(json, CANCEL_ACTIVITY_INSTANCES, activityInstanceCancellationCmd.getActivityInstanceId());
            JsonUtil.addField(json, PROCESS_INSTANCE, activityInstanceCancellationCmd.getProcessInstanceId());
        } else if (command instanceof TransitionInstanceCancellationCmd) {
            TransitionInstanceCancellationCmd transitionInstanceCancellationCmd = (TransitionInstanceCancellationCmd)command;
            JsonUtil.addField(json, CANCEL_TRANSITION_INSTANCES, transitionInstanceCancellationCmd.getTransitionInstanceId());
            JsonUtil.addField(json, PROCESS_INSTANCE, transitionInstanceCancellationCmd.getProcessInstanceId());
        }
        return json;
    }

    @Override
    public AbstractProcessInstanceModificationCommand toObject(JsonObject json) {
        AbstractProcessInstanceModificationCommand cmd = null;
        if (json.has(START_BEFORE)) {
            cmd = new ActivityBeforeInstantiationCmd(JsonUtil.getString(json, START_BEFORE));
            if (json.has(ANCESTOR_ACTIVITY_INSTANCE_ID)) {
                cmd.setAncestorActivityInstanceId(JsonUtil.getString(json, ANCESTOR_ACTIVITY_INSTANCE_ID));
            }
        } else if (json.has(START_AFTER)) {
            cmd = new ActivityAfterInstantiationCmd(JsonUtil.getString(json, START_AFTER));
            if (json.has(ANCESTOR_ACTIVITY_INSTANCE_ID)) {
                ((ActivityAfterInstantiationCmd)cmd).setAncestorActivityInstanceId(JsonUtil.getString(json, ANCESTOR_ACTIVITY_INSTANCE_ID));
            }
        } else if (json.has(START_TRANSITION)) {
            cmd = new TransitionInstantiationCmd(JsonUtil.getString(json, START_TRANSITION));
        } else if (json.has(CANCEL_ALL)) {
            cmd = new ActivityCancellationCmd(JsonUtil.getString(json, CANCEL_ALL));
            boolean cancelCurrentActiveActivityInstances = JsonUtil.getBoolean(json, CANCEL_CURRENT);
            ((ActivityCancellationCmd)cmd).setCancelCurrentActiveActivityInstances(cancelCurrentActiveActivityInstances);
        } else if (json.has(CANCEL_ACTIVITY_INSTANCES)) {
            cmd = new ActivityInstanceCancellationCmd(JsonUtil.getString(json, PROCESS_INSTANCE), JsonUtil.getString(json, CANCEL_ACTIVITY_INSTANCES));
        } else if (json.has(CANCEL_TRANSITION_INSTANCES)) {
            cmd = new TransitionInstanceCancellationCmd(JsonUtil.getString(json, PROCESS_INSTANCE), JsonUtil.getString(json, CANCEL_TRANSITION_INSTANCES));
        }
        return cmd;
    }
}

