/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.metrics.reporter;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.metrics.Meter;
import org.operaton.bpm.engine.impl.metrics.MetricsLogger;
import org.operaton.bpm.engine.impl.metrics.MetricsRegistry;
import org.operaton.bpm.engine.impl.persistence.entity.MeterLogEntity;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public class MetricsCollectionTask
extends TimerTask {
    private static final MetricsLogger LOG = ProcessEngineLogger.METRICS_LOGGER;
    protected MetricsRegistry metricsRegistry;
    protected CommandExecutor commandExecutor;
    protected String reporterId;

    public MetricsCollectionTask(MetricsRegistry metricsRegistry, CommandExecutor commandExecutor) {
        this.metricsRegistry = metricsRegistry;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void run() {
        try {
            this.collectMetrics();
        }
        catch (Exception e) {
            try {
                LOG.couldNotCollectAndLogMetrics(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void collectMetrics() {
        ArrayList<MeterLogEntity> logs = new ArrayList<MeterLogEntity>();
        for (Meter meter : this.metricsRegistry.getDbMeters().values()) {
            logs.add(new MeterLogEntity(meter.getName(), this.reporterId, meter.getAndClear(), ClockUtil.getCurrentTime()));
        }
        this.commandExecutor.execute(new MetricsCollectionCmd(logs));
    }

    public String getReporter() {
        return this.reporterId;
    }

    public void setReporter(String reporterId) {
        this.reporterId = reporterId;
    }

    protected class MetricsCollectionCmd
    implements Command<Void> {
        protected List<MeterLogEntity> logs;

        public MetricsCollectionCmd(List<MeterLogEntity> logs) {
            this.logs = logs;
        }

        @Override
        public Void execute(CommandContext commandContext) {
            for (MeterLogEntity meterLogEntity : this.logs) {
                commandContext.getMeterLogManager().insert(meterLogEntity);
            }
            return null;
        }
    }
}

