/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.DeploymentMapping;
import org.operaton.bpm.engine.impl.batch.DeploymentMappings;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.core.variable.VariableUtil;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.migration.AbstractMigrationCmd;
import org.operaton.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.operaton.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.migration.MigrationPlan;
import org.operaton.bpm.engine.variable.VariableMap;

public class MigrateProcessInstanceBatchCmd
extends AbstractMigrationCmd
implements Command<Batch> {
    public MigrateProcessInstanceBatchCmd(MigrationPlanExecutionBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        Collection<String> collectedInstanceIds = this.collectProcessInstanceIds();
        MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", collectedInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", collectedInstanceIds);
        ProcessDefinitionEntity sourceDefinition = this.resolveSourceProcessDefinition(commandContext);
        ProcessDefinitionEntity targetDefinition = this.resolveTargetProcessDefinition(commandContext);
        String tenantId = sourceDefinition.getTenantId();
        VariableMap variables = migrationPlan.getVariables();
        Batch batch = new BatchBuilder(commandContext).type("instance-migration").config(this.getConfiguration(collectedInstanceIds, sourceDefinition.getDeploymentId())).permission(BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES).permissionHandler(ctx -> this.checkAuthorizations(ctx, sourceDefinition, targetDefinition)).tenantId(tenantId).operationLogHandler((arg_0, arg_1) -> this.lambda$execute$1(sourceDefinition, targetDefinition, (Map)variables, arg_0, arg_1)).build();
        if (variables != null) {
            String batchId = batch.getId();
            VariableUtil.setVariablesByBatchId(variables, batchId);
        }
        return batch;
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds, String deploymentId) {
        return new MigrationBatchConfiguration(new ArrayList<String>(instanceIds), DeploymentMappings.of(new DeploymentMapping(deploymentId, instanceIds.size())), this.executionBuilder.getMigrationPlan(), this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings());
    }

    private /* synthetic */ void lambda$execute$1(ProcessDefinitionEntity sourceDefinition, ProcessDefinitionEntity targetDefinition, Map variables, CommandContext ctx, int instanceCount) {
        this.writeUserOperationLog(ctx, sourceDefinition, targetDefinition, instanceCount, variables, true);
    }
}

