/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.validation.instruction;

import java.util.List;
import org.operaton.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;

public class SameEventScopeInstructionValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        if (this.isCompensationBoundaryEvent(sourceActivity)) {
            return;
        }
        ScopeImpl sourceEventScope = instruction.getSourceActivity().getEventScope();
        ScopeImpl targetEventScope = instruction.getTargetActivity().getEventScope();
        if (sourceEventScope == null || sourceEventScope == sourceActivity.getFlowScope()) {
            return;
        }
        if (targetEventScope == null) {
            if (!this.isUserTaskWithTimeoutListener(sourceActivity)) {
                report.addFailure("The source activity's event scope (" + sourceEventScope.getId() + ") must be mapped but the target activity has no event scope");
            }
        } else {
            ScopeImpl mappedSourceEventScope = this.findMappedEventScope(sourceEventScope, instruction, instructions);
            if (mappedSourceEventScope == null || !mappedSourceEventScope.getId().equals(targetEventScope.getId())) {
                report.addFailure("The source activity's event scope (" + sourceEventScope.getId() + ") must be mapped to the target activity's event scope (" + targetEventScope.getId() + ")");
            }
        }
    }

    protected boolean isCompensationBoundaryEvent(ActivityImpl sourceActivity) {
        String activityType = sourceActivity.getProperties().get(BpmnProperties.TYPE);
        return "compensationBoundaryCatch".equals(activityType);
    }

    protected boolean isUserTaskWithTimeoutListener(ActivityImpl sourceActivity) {
        return "userTask".equals(sourceActivity.getProperties().get(BpmnProperties.TYPE)) && sourceActivity.isScope() && sourceActivity.equals(sourceActivity.getEventScope()) && sourceActivity.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS) != null && !sourceActivity.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS).isEmpty();
    }

    protected ScopeImpl findMappedEventScope(ScopeImpl sourceEventScope, ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions) {
        if (sourceEventScope != null) {
            if (sourceEventScope == sourceEventScope.getProcessDefinition()) {
                return instruction.getTargetActivity().getProcessDefinition();
            }
            List<ValidatingMigrationInstruction> eventScopeInstructions = instructions.getInstructionsBySourceScope(sourceEventScope);
            if (!eventScopeInstructions.isEmpty()) {
                return eventScopeInstructions.get(0).getTargetActivity();
            }
        }
        return null;
    }

    protected void addFailure(ValidatingMigrationInstruction instruction, MigrationInstructionValidationReportImpl report, String sourceScopeId, String targetScopeId) {
        report.addFailure("The source activity's event scope (" + sourceScopeId + ") must be mapped to the target activity's event scope (" + targetScopeId + ")");
    }
}

