/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.deploy.cache;

import java.io.InputStream;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.ModelInstanceCache;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.repository.ProcessDefinition;
import org.operaton.bpm.model.bpmn.Bpmn;
import org.operaton.bpm.model.bpmn.BpmnModelInstance;

public class BpmnModelInstanceCache
extends ModelInstanceCache<BpmnModelInstance, ProcessDefinitionEntity> {
    public BpmnModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<ProcessDefinitionEntity> definitionCache) {
        super(factory, cacheCapacity, definitionCache);
    }

    @Override
    protected void throwLoadModelException(String definitionId, Exception e) {
        throw LOG.loadModelException("BPMN", "process", definitionId, e);
    }

    @Override
    protected BpmnModelInstance readModelFromStream(InputStream bpmnResourceInputStream) {
        return Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
    }

    @Override
    protected void logRemoveEntryFromDeploymentCacheFailure(String definitionId, Exception e) {
        LOG.removeEntryFromDeploymentCacheFailure("process", definitionId, e);
    }

    @Override
    protected List<ProcessDefinition> getAllDefinitionsForDeployment(String deploymentId) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.runWithoutAuthorization(() -> new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list());
    }
}

