/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.deploy.cache;

import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class ProcessDefinitionCache
extends ResourceDefinitionCache<ProcessDefinitionEntity> {
    private static final String VAR_PROCESS_DEFINITION = "processDefinition";
    private static final String VAR_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String VAR_CACHED_PROCESS_DEFINITION = "cachedProcessDefinition";

    public ProcessDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    @Override
    protected AbstractResourceDefinitionManager<ProcessDefinitionEntity> getManager() {
        return Context.getCommandContext().getProcessDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid process definition id", VAR_PROCESS_DEFINITION_ID, (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(NotFoundException.class, "no deployed process definition found with id '" + definitionId + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key '" + definitionKey + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "', version = '" + definitionVersion + "' and tenant-id = '" + tenantId + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "', versionTag = '" + definitionVersionTag + "' and tenant-id = '" + tenantId + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + definitionKey + "' in deployment = '" + deploymentId + "'", VAR_PROCESS_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, ProcessDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put process definition '" + definitionId + "' in the cache", VAR_CACHED_PROCESS_DEFINITION, (Object)definition);
    }
}

