/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.operaton.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.operaton.bpm.engine.task.Attachment;

public class AttachmentManager
extends AbstractHistoricManager {
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectAttachmentsByTaskId", taskId);
    }

    public DbOperation addRemovalTimeToAttachmentsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(AttachmentEntity.class, "updateAttachmentsByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToAttachmentsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(AttachmentEntity.class, "updateAttachmentsByProcessInstanceId", parameters);
    }

    public void deleteAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        List attachments = this.getDbEntityManager().selectList("selectAttachmentsByTaskId", taskId);
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayManager().deleteByteArrayById(contentId);
            }
            this.getDbEntityManager().delete(attachment);
        }
    }

    public void deleteAttachmentsByProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", processInstanceIds);
        this.deleteAttachments(parameters);
    }

    public void deleteAttachmentsByTaskProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", processInstanceIds);
        this.deleteAttachments(parameters);
    }

    public void deleteAttachmentsByTaskCaseInstanceIds(List<String> caseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseInstanceIds", caseInstanceIds);
        this.deleteAttachments(parameters);
    }

    protected void deleteAttachments(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteAttachmentByteArraysByIds", parameters);
        this.getDbEntityManager().deletePreserveOrder(AttachmentEntity.class, "deleteAttachmentByIds", parameters);
    }

    public Attachment findAttachmentByTaskIdAndAttachmentId(String taskId, String attachmentId) {
        this.checkHistoryEnabled();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("id", attachmentId);
        return (AttachmentEntity)this.getDbEntityManager().selectOne("selectAttachmentByTaskIdAndAttachmentId", parameters);
    }

    public DbOperation deleteAttachmentsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(AttachmentEntity.class, "deleteAttachmentsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

