/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.HasDbReferences;
import org.operaton.bpm.engine.impl.db.HasDbRevision;
import org.operaton.bpm.engine.impl.event.EventHandler;
import org.operaton.bpm.engine.impl.event.EventType;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.MessageEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.EventSubscription;

public class EventSubscriptionEntity
implements EventSubscription,
DbEntity,
HasDbRevision,
HasDbReferences,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision = 1;
    protected String eventType;
    protected String eventName;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;
    protected String configuration;
    protected Date created;
    protected String tenantId;
    protected ExecutionEntity execution;
    protected ActivityImpl activity;
    protected EventSubscriptionJobDeclaration jobDeclaration;

    public EventSubscriptionEntity() {
    }

    public EventSubscriptionEntity(EventType eventType) {
        this.created = ClockUtil.getCurrentTime();
        this.eventType = eventType.name();
    }

    public EventSubscriptionEntity(ExecutionEntity executionEntity, EventType eventType) {
        this(eventType);
        this.setExecution(executionEntity);
        this.setActivity(this.execution.getActivity());
        this.processInstanceId = executionEntity.getProcessInstanceId();
        this.tenantId = executionEntity.getTenantId();
    }

    public void eventReceived(Object payload, boolean processASync) {
        this.eventReceived(payload, null, null, null, processASync);
    }

    public void eventReceived(Object payload, Object payloadLocal, Object payloadToTriggeredScope, String businessKey, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(payload, payloadLocal, payloadToTriggeredScope, businessKey);
        } else {
            this.processEventSync(payload, payloadLocal, payloadToTriggeredScope, businessKey);
        }
    }

    protected void processEventSync(Object payload) {
        this.processEventSync(payload, null, null, null);
    }

    protected void processEventSync(Object payload, Object payloadLocal, Object payloadToTriggeredScope, String businessKey) {
        EventHandler eventHandler = Context.getProcessEngineConfiguration().getEventHandler(this.eventType);
        EnsureUtil.ensureNotNull("Could not find eventhandler for event of type '" + this.eventType + "'", "eventHandler", (Object)eventHandler);
        eventHandler.handleEvent(this, payload, payloadLocal, payloadToTriggeredScope, businessKey, Context.getCommandContext());
    }

    protected void scheduleEventAsync(Object payload, Object payloadLocal, Object payloadToTriggeredScope, String businessKey) {
        EventSubscriptionJobDeclaration asyncDeclaration = this.getJobDeclaration();
        if (asyncDeclaration == null) {
            this.processEventSync(payload, payloadLocal, payloadToTriggeredScope, businessKey);
        } else {
            MessageEntity message = (MessageEntity)asyncDeclaration.createJobInstance(this);
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getJobManager().send(message);
        }
    }

    public void delete() {
        Context.getCommandContext().getEventSubscriptionManager().deleteEventSubscription(this);
        this.removeFromExecution();
    }

    public void insert() {
        Context.getCommandContext().getEventSubscriptionManager().insert(this);
        this.addToExecution();
    }

    public static EventSubscriptionEntity createAndInsert(ExecutionEntity executionEntity, EventType eventType, ActivityImpl activity) {
        return EventSubscriptionEntity.createAndInsert(executionEntity, eventType, activity, null);
    }

    public static EventSubscriptionEntity createAndInsert(ExecutionEntity executionEntity, EventType eventType, ActivityImpl activity, String configuration) {
        EventSubscriptionEntity eventSubscription = new EventSubscriptionEntity(executionEntity, eventType);
        eventSubscription.setActivity(activity);
        eventSubscription.setTenantId(executionEntity.getTenantId());
        eventSubscription.setConfiguration(configuration);
        eventSubscription.insert();
        return eventSubscription;
    }

    protected void addToExecution() {
        ExecutionEntity exec = this.getExecution();
        if (exec != null) {
            exec.addEventSubscription(this);
        }
    }

    protected void removeFromExecution() {
        ExecutionEntity exec = this.getExecution();
        if (exec != null) {
            exec.removeEventSubscription(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("executionId", this.executionId);
        persistentState.put("configuration", this.configuration);
        persistentState.put("activityId", this.activityId);
        persistentState.put("eventName", this.eventName);
        return persistentState;
    }

    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        if (execution != null) {
            this.execution = execution;
            this.executionId = execution.getId();
            this.addToExecution();
        } else {
            this.removeFromExecution();
            this.executionId = null;
            this.execution = null;
        }
    }

    public ActivityImpl getActivity() {
        if (this.activity == null && this.activityId != null) {
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition();
            this.activity = processDefinition.findActivity(this.activityId);
        }
        return this.activity;
    }

    public ProcessDefinitionEntity getProcessDefinition() {
        if (this.executionId != null) {
            return this.getExecution().getProcessDefinition();
        }
        String processDefinitionId = this.getConfiguration();
        return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        if (activity != null) {
            this.activityId = activity.getId();
        }
    }

    public EventSubscriptionJobDeclaration getJobDeclaration() {
        if (this.jobDeclaration == null) {
            this.jobDeclaration = EventSubscriptionJobDeclaration.findDeclarationForSubscription(this);
        }
        return this.jobDeclaration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public boolean isSubscriptionForEventType(EventType eventType) {
        return this.eventType.equals(eventType.name());
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
        this.activity = null;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.id == null ? 0 : this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventSubscriptionEntity other = (EventSubscriptionEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        return new HashSet<String>();
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.executionId != null) {
            referenceIdAndClass.put(this.executionId, ExecutionEntity.class);
        }
        return referenceIdAndClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", eventType=" + this.eventType + ", eventName=" + this.eventName + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", activityId=" + this.activityId + ", tenantId=" + this.tenantId + ", configuration=" + this.configuration + ", revision=" + this.revision + ", created=" + String.valueOf(this.created) + "]";
    }
}

